/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedExporter;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class HttpInvokerServiceExporter
extends RemoteInvocationBasedExporter
implements Controller,
InitializingBean {
    protected static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    private Object proxy;

    public void afterPropertiesSet() {
        this.proxy = this.getProxyForService();
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ClassNotFoundException {
        RemoteInvocation invocation = this.readRemoteInvocation(request);
        RemoteInvocationResult result = this.invokeAndCreateResult(invocation, this.proxy);
        this.writeRemoteInvocationResult(response, result);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream((InputStream)request.getInputStream());
        try {
            RemoteInvocation invocation;
            Object obj = ois.readObject();
            if (!(obj instanceof RemoteInvocation)) {
                throw new IOException("Deserialized object needs to be a RemoteInvocation: " + obj);
            }
            RemoteInvocation remoteInvocation = invocation = (RemoteInvocation)obj;
            return remoteInvocation;
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRemoteInvocationResult(HttpServletResponse response, RemoteInvocationResult result) throws IOException {
        response.setContentType(CONTENT_TYPE_SERIALIZED_OBJECT);
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            oos.writeObject(result);
        }
        finally {
            oos.close();
        }
    }
}

