/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.jdbcjobstore;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.Constants;
import org.quartz.impl.jdbcjobstore.DriverDelegate;
import org.quartz.impl.jdbcjobstore.FiredTriggerRecord;
import org.quartz.impl.jdbcjobstore.InvalidConfigurationException;
import org.quartz.impl.jdbcjobstore.LockException;
import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.SchedulerStateRecord;
import org.quartz.impl.jdbcjobstore.Semaphore;
import org.quartz.impl.jdbcjobstore.SimpleSemaphore;
import org.quartz.impl.jdbcjobstore.StdRowLockSemaphore;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.JobStore;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.utils.DBConnectionManager;
import org.quartz.utils.Key;
import org.quartz.utils.TriggerStatus;

public abstract class JobStoreSupport
implements JobStore,
Constants {
    protected static String LOCK_TRIGGER_ACCESS = "TRIGGER_ACCESS";
    protected static String LOCK_JOB_ACCESS = "JOB_ACCESS";
    protected static String LOCK_CALENDAR_ACCESS = "CALENDAR_ACCESS";
    protected static String LOCK_STATE_ACCESS = "STATE_ACCESS";
    protected static String LOCK_MISFIRE_ACCESS = "MISFIRE_ACCESS";
    protected String dsName;
    protected String tablePrefix = "QRTZ_";
    protected boolean useProperties = false;
    protected String instanceId;
    protected String instanceName;
    protected Class delegateClass = class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate == null ? (class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate = JobStoreSupport.class$("org.quartz.impl.jdbcjobstore.StdJDBCDelegate")) : class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate;
    protected HashMap calendarCache = new HashMap();
    private DriverDelegate delegate;
    private long misfireThreshold = 60000L;
    private boolean dontSetAutoCommitFalse = false;
    private boolean isClustered = false;
    private boolean useDBLocks = false;
    private boolean lockOnInsert = true;
    private Semaphore lockHandler = null;
    private String selectWithLockSQL = null;
    private long clusterCheckinInterval = 7500L;
    private ClusterManager clusterManagementThread = null;
    private MisfireHandler misfireHandler = null;
    private ClassLoadHelper classLoadHelper;
    private SchedulerSignaler signaler;
    protected int maxToRecoverAtATime = 20;
    private boolean setTxIsolationLevelSequential = false;
    private long dbRetryInterval = 10000L;
    private int lastRecoverCount = 0;
    private static long ftrCtr = System.currentTimeMillis();
    protected boolean firstCheckIn = true;
    protected long lastCheckin = System.currentTimeMillis();
    static /* synthetic */ Class class$org$quartz$impl$jdbcjobstore$StdJDBCDelegate;
    static /* synthetic */ Class class$org$apache$commons$logging$Log;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void setDataSource(String dsName) {
        this.dsName = dsName;
    }

    public String getDataSource() {
        return this.dsName;
    }

    public void setTablePrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.tablePrefix = prefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setUseProperties(String useProp) {
        if (useProp == null) {
            useProp = "false";
        }
        this.useProperties = Boolean.valueOf(useProp);
    }

    public boolean canUseProperties() {
        return this.useProperties;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setIsClustered(boolean isClustered) {
        this.isClustered = isClustered;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public long getClusterCheckinInterval() {
        return this.clusterCheckinInterval;
    }

    public void setClusterCheckinInterval(long l) {
        this.clusterCheckinInterval = l;
    }

    public int getMaxMisfiresToHandleAtATime() {
        return this.maxToRecoverAtATime;
    }

    public void setMaxMisfiresToHandleAtATime(int maxToRecoverAtATime) {
        this.maxToRecoverAtATime = maxToRecoverAtATime;
    }

    public long getDbRetryInterval() {
        return this.dbRetryInterval;
    }

    public void setDbRetryInterval(long dbRetryInterval) {
        this.dbRetryInterval = dbRetryInterval;
    }

    public void setUseDBLocks(boolean useDBLocks) {
        this.useDBLocks = useDBLocks;
    }

    public boolean getUseDBLocks() {
        return this.useDBLocks;
    }

    public boolean isLockOnInsert() {
        return this.lockOnInsert;
    }

    public void setLockOnInsert(boolean lockOnInsert) {
        this.lockOnInsert = lockOnInsert;
    }

    public long getMisfireThreshold() {
        return this.misfireThreshold;
    }

    public void setMisfireThreshold(long misfireThreshold) {
        if (misfireThreshold < 1L) {
            throw new IllegalArgumentException("Misfirethreashold must be larger than 0");
        }
        this.misfireThreshold = misfireThreshold;
    }

    public boolean isDontSetAutoCommitFalse() {
        return this.dontSetAutoCommitFalse;
    }

    public void setDontSetAutoCommitFalse(boolean b) {
        this.dontSetAutoCommitFalse = b;
    }

    public boolean isTxIsolationLevelSerializable() {
        return this.setTxIsolationLevelSequential;
    }

    public void setTxIsolationLevelSerializable(boolean b) {
        this.setTxIsolationLevelSequential = b;
    }

    public void setDriverDelegateClass(String delegateClassName) throws InvalidConfigurationException {
        try {
            this.delegateClass = Thread.currentThread().getContextClassLoader().loadClass(delegateClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Invalid delegate class: " + delegateClassName);
        }
    }

    public String getDriverDelegateClass() {
        return this.delegateClass.getName();
    }

    public String getSelectWithLockSQL() {
        return this.selectWithLockSQL;
    }

    public void setSelectWithLockSQL(String string) {
        this.selectWithLockSQL = string;
    }

    protected ClassLoadHelper getClassLoadHelper() {
        return this.classLoadHelper;
    }

    Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        if (this.dsName == null) {
            throw new SchedulerConfigException("DataSource name not set.");
        }
        this.classLoadHelper = loadHelper;
        this.signaler = signaler;
        if (!this.getUseDBLocks() && !this.isClustered()) {
            this.getLog().info((Object)"Using thread monitor-based data access locking (synchronization).");
            this.lockHandler = new SimpleSemaphore();
        } else {
            this.getLog().info((Object)"Using db table-based data access locking (synchronization).");
            this.lockHandler = new StdRowLockSemaphore(this.getTablePrefix(), this.getSelectWithLockSQL());
        }
        if (!this.isClustered()) {
            try {
                this.cleanVolatileTriggerAndJobs();
                this.recoverJobs();
            }
            catch (SchedulerException se) {
                throw new SchedulerConfigException("Failure occured during job recovery.", se);
            }
        } else {
            this.clusterManagementThread = new ClusterManager(this);
            this.clusterManagementThread.initialize();
        }
        this.misfireHandler = new MisfireHandler(this);
        this.misfireHandler.initialize();
    }

    public void shutdown() {
        if (this.clusterManagementThread != null) {
            this.clusterManagementThread.shutdown();
        }
        if (this.misfireHandler != null) {
            this.misfireHandler.shutdown();
        }
        try {
            DBConnectionManager.getInstance().shutdown(this.getDataSource());
        }
        catch (SQLException sqle) {
            this.getLog().warn((Object)"Database connection shutdown unsuccessful.", (Throwable)sqle);
        }
    }

    public boolean supportsPersistence() {
        return true;
    }

    protected Connection getConnection() throws JobPersistenceException {
        try {
            Connection conn = DBConnectionManager.getInstance().getConnection(this.getDataSource());
            if (conn == null) {
                throw new SQLException("Could not get connection from DataSource '" + this.getDataSource() + "'");
            }
            try {
                if (!this.isDontSetAutoCommitFalse()) {
                    conn.setAutoCommit(false);
                }
                if (this.isTxIsolationLevelSerializable()) {
                    conn.setTransactionIsolation(8);
                }
            }
            catch (SQLException ingore) {
                // empty catch block
            }
            return conn;
        }
        catch (SQLException sqle) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + sqle.toString(), sqle);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Failed to obtain DB connection from data source '" + this.getDataSource() + "': " + e.toString(), e, 499);
        }
    }

    protected void releaseLock(Connection conn, String lockName, boolean doIt) {
        if (doIt && conn != null) {
            try {
                this.getLockHandler().releaseLock(conn, lockName);
            }
            catch (LockException le) {
                this.getLog().error((Object)("Error returning lock: " + le.getMessage()), (Throwable)le);
            }
        }
    }

    protected abstract void cleanVolatileTriggerAndJobs() throws JobPersistenceException;

    protected void cleanVolatileTriggerAndJobs(Connection conn) throws JobPersistenceException {
        try {
            Key[] volatileTriggers = this.getDelegate().selectVolatileTriggers(conn);
            Key[] volatileJobs = this.getDelegate().selectVolatileJobs(conn);
            int i = 0;
            while (i < volatileTriggers.length) {
                this.removeTrigger(conn, null, volatileTriggers[i].getName(), volatileTriggers[i].getGroup());
                ++i;
            }
            this.getLog().info((Object)("Removed " + volatileTriggers.length + " Volatile Trigger(s)."));
            int i2 = 0;
            while (i2 < volatileJobs.length) {
                this.removeJob(conn, null, volatileJobs[i2].getName(), volatileJobs[i2].getGroup(), true);
                ++i2;
            }
            this.getLog().info((Object)("Removed " + volatileJobs.length + " Volatile Job(s)."));
            this.getDelegate().deleteVolatileFiredTriggers(conn);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't clean volatile data: " + e.getMessage(), e);
        }
    }

    protected abstract void recoverJobs() throws JobPersistenceException;

    protected void recoverJobs(Connection conn) throws JobPersistenceException {
        try {
            int rows = this.getDelegate().updateTriggerStatesFromOtherStates(conn, "WAITING", "ACQUIRED", "BLOCKED");
            this.getLog().info((Object)("Freed " + rows + " triggers from 'acquired' / 'blocked' state."));
            this.getDelegate().updateTriggerStateFromOtherStatesBeforeTime(conn, "MISFIRED", "WAITING", "WAITING", this.getMisfireTime());
            this.recoverMisfiredJobs(conn, true);
            Trigger[] recoveringJobTriggers = this.getDelegate().selectTriggersForRecoveringJobs(conn);
            this.getLog().info((Object)("Recovering " + recoveringJobTriggers.length + " jobs that were in-progress at the time of the last shut-down."));
            int i = 0;
            while (i < recoveringJobTriggers.length) {
                if (this.jobExists(conn, recoveringJobTriggers[i].getJobName(), recoveringJobTriggers[i].getJobGroup())) {
                    recoveringJobTriggers[i].computeFirstFireTime(null);
                    this.storeTrigger(conn, null, recoveringJobTriggers[i], null, false, "WAITING", false, true);
                }
                ++i;
            }
            this.getLog().info((Object)"Recovery complete.");
            Key[] ct = this.getDelegate().selectTriggersInState(conn, "COMPLETE");
            int i2 = 0;
            while (ct != null && i2 < ct.length) {
                this.removeTrigger(conn, null, ct[i2].getName(), ct[i2].getGroup());
                ++i2;
            }
            this.getLog().info((Object)("Removed " + ct.length + " 'complete' triggers."));
            int n = this.getDelegate().deleteFiredTriggers(conn);
            this.getLog().info((Object)("Removed " + n + " stale fired job entries."));
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't recover jobs: " + e.getMessage(), e);
        }
    }

    protected long getMisfireTime() {
        long misfireTime = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            misfireTime -= this.getMisfireThreshold();
        }
        return misfireTime;
    }

    protected boolean recoverMisfiredJobs(Connection conn, boolean recovering) throws JobPersistenceException, NoSuchDelegateException, SQLException, ClassNotFoundException, IOException {
        Key[] misfiredTriggers = this.getDelegate().selectTriggersInState(conn, "MISFIRED");
        if (misfiredTriggers.length > 0 && misfiredTriggers.length > this.getMaxMisfiresToHandleAtATime()) {
            this.getLog().info((Object)("Handling " + this.getMaxMisfiresToHandleAtATime() + " of " + misfiredTriggers.length + " triggers that missed their scheduled fire-time."));
        } else if (misfiredTriggers.length > 0) {
            this.getLog().info((Object)("Handling " + misfiredTriggers.length + " triggers that missed their scheduled fire-time."));
        } else {
            this.getLog().debug((Object)"Found 0 triggers that missed their scheduled fire-time.");
        }
        this.lastRecoverCount = misfiredTriggers.length;
        int i = 0;
        while (i < misfiredTriggers.length && i < this.getMaxMisfiresToHandleAtATime()) {
            Trigger trig = this.getDelegate().selectTrigger(conn, misfiredTriggers[i].getName(), misfiredTriggers[i].getGroup());
            if (trig != null) {
                Calendar cal = null;
                if (trig.getCalendarName() != null) {
                    cal = this.retrieveCalendar(conn, null, trig.getCalendarName());
                }
                String[] listeners = this.getDelegate().selectTriggerListeners(conn, trig.getName(), trig.getGroup());
                int l = 0;
                while (l < listeners.length) {
                    trig.addTriggerListener(listeners[l]);
                    ++l;
                }
                this.signaler.notifyTriggerListenersMisfired(trig);
                trig.updateAfterMisfire(cal);
                if (trig.getNextFireTime() == null) {
                    this.storeTrigger(conn, null, trig, null, true, "COMPLETE", false, recovering);
                } else {
                    this.storeTrigger(conn, null, trig, null, true, "WAITING", false, recovering);
                }
            }
            ++i;
        }
        return misfiredTriggers.length > this.getMaxMisfiresToHandleAtATime();
    }

    protected boolean updateMisfiredTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName, String newStateIfNotComplete, boolean forceState) throws JobPersistenceException {
        try {
            Trigger trig = this.getDelegate().selectTrigger(conn, triggerName, groupName);
            long misfireTime = System.currentTimeMillis();
            if (this.getMisfireThreshold() > 0L) {
                misfireTime -= this.getMisfireThreshold();
            }
            if (trig.getNextFireTime().getTime() > misfireTime) {
                return false;
            }
            Calendar cal = null;
            if (trig.getCalendarName() != null) {
                cal = this.retrieveCalendar(conn, ctxt, trig.getCalendarName());
            }
            this.signaler.notifyTriggerListenersMisfired(trig);
            trig.updateAfterMisfire(cal);
            if (trig.getNextFireTime() == null) {
                this.storeTrigger(conn, ctxt, trig, null, true, "COMPLETE", forceState, false);
            } else {
                this.storeTrigger(conn, ctxt, trig, null, true, newStateIfNotComplete, forceState, false);
            }
            return true;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't update misfired trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    protected void storeJob(Connection conn, SchedulingContext ctxt, JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (newJob.isVolatile() && this.isClustered()) {
            this.getLog().info((Object)"note: volatile jobs are effectively non-volatile in a clustered environment.");
        }
        boolean existingJob = this.jobExists(conn, newJob.getName(), newJob.getGroup());
        try {
            if (existingJob) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newJob);
                }
                this.getDelegate().updateJobDetail(conn, newJob);
            } else {
                this.getDelegate().insertJobDetail(conn, newJob);
            }
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't store job: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't store job: " + e.getMessage(), e);
        }
    }

    protected boolean jobExists(Connection conn, String jobName, String groupName) throws JobPersistenceException {
        try {
            return this.getDelegate().jobExists(conn, jobName, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine job existence (" + groupName + "." + jobName + "): " + e.getMessage(), e);
        }
    }

    protected void storeTrigger(Connection conn, SchedulingContext ctxt, Trigger newTrigger, JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws ObjectAlreadyExistsException, JobPersistenceException {
        if (newTrigger.isVolatile() && this.isClustered()) {
            this.getLog().info((Object)"note: volatile triggers are effectively non-volatile in a clustered environment.");
        }
        boolean existingTrigger = this.triggerExists(conn, newTrigger.getName(), newTrigger.getGroup());
        try {
            boolean shouldBepaused = false;
            if (!forceState) {
                shouldBepaused = this.getDelegate().isTriggerGroupPaused(conn, newTrigger.getGroup());
                if (!shouldBepaused && (shouldBepaused = this.getDelegate().isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_"))) {
                    this.getDelegate().insertPausedTriggerGroup(conn, newTrigger.getGroup());
                }
                if (shouldBepaused && (state.equals("WAITING") || state.equals("ACQUIRED"))) {
                    state = "PAUSED";
                }
            }
            if (job == null) {
                job = this.getDelegate().selectJobDetail(conn, newTrigger.getJobName(), newTrigger.getJobGroup(), this.getClassLoadHelper());
            }
            if (job == null) {
                throw new JobPersistenceException("The job (" + newTrigger.getFullJobName() + ") referenced by the trigger does not exist.");
            }
            if (job.isVolatile() && !newTrigger.isVolatile()) {
                throw new JobPersistenceException("It does not make sense to associate a non-volatile Trigger with a volatile Job!");
            }
            if (job.isStateful() && !recovering && state.equals("WAITING")) {
                state = this.getNewStatusForTrigger(conn, ctxt, job.getName(), job.getGroup());
            }
            if (existingTrigger) {
                if (!replaceExisting) {
                    throw new ObjectAlreadyExistsException(newTrigger);
                }
                if (newTrigger instanceof SimpleTrigger) {
                    this.getDelegate().updateSimpleTrigger(conn, (SimpleTrigger)newTrigger);
                } else if (newTrigger instanceof CronTrigger) {
                    this.getDelegate().updateCronTrigger(conn, (CronTrigger)newTrigger);
                } else {
                    this.getDelegate().updateBlobTrigger(conn, newTrigger);
                }
                this.getDelegate().updateTrigger(conn, newTrigger, state, job);
            } else {
                this.getDelegate().insertTrigger(conn, newTrigger, state, job);
                if (newTrigger instanceof SimpleTrigger) {
                    this.getDelegate().insertSimpleTrigger(conn, (SimpleTrigger)newTrigger);
                } else if (newTrigger instanceof CronTrigger) {
                    this.getDelegate().insertCronTrigger(conn, (CronTrigger)newTrigger);
                } else {
                    this.getDelegate().insertBlobTrigger(conn, newTrigger);
                }
            }
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't store trigger: " + e.getMessage(), e);
        }
    }

    protected boolean triggerExists(Connection conn, String triggerName, String groupName) throws JobPersistenceException {
        try {
            return this.getDelegate().triggerExists(conn, triggerName, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine trigger existence (" + groupName + "." + triggerName + "): " + e.getMessage(), e);
        }
    }

    protected boolean removeJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName, boolean activeDeleteSafe) throws JobPersistenceException {
        try {
            Key[] jobTriggers = this.getDelegate().selectTriggerNamesForJob(conn, jobName, groupName);
            int i = 0;
            while (i < jobTriggers.length) {
                this.getDelegate().deleteSimpleTrigger(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
                this.getDelegate().deleteCronTrigger(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
                this.getDelegate().deleteBlobTrigger(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
                this.getDelegate().deleteTriggerListeners(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
                this.getDelegate().deleteTrigger(conn, jobTriggers[i].getName(), jobTriggers[i].getGroup());
                ++i;
            }
            this.getDelegate().deleteJobListeners(conn, jobName, groupName);
            return this.getDelegate().deleteJobDetail(conn, jobName, groupName) > 0;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove job: " + e.getMessage(), e);
        }
    }

    protected JobDetail retrieveJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        try {
            JobDetail job = this.getDelegate().selectJobDetail(conn, jobName, groupName, this.getClassLoadHelper());
            String[] listeners = this.getDelegate().selectJobListeners(conn, jobName, groupName);
            int i = 0;
            while (i < listeners.length) {
                job.addJobListener(listeners[i]);
                ++i;
            }
            return job;
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't retrieve job because a required class was not found: " + e.getMessage(), e, 410);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't retrieve job because the BLOB couldn't be deserialized: " + e.getMessage(), e, 410);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't retrieve job: " + e.getMessage(), e);
        }
    }

    protected boolean removeTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        boolean removedTrigger = false;
        try {
            int numTriggers;
            JobDetail job = this.getDelegate().selectJobForTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteSimpleTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteCronTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteBlobTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteTriggerListeners(conn, triggerName, groupName);
            boolean bl = removedTrigger = this.getDelegate().deleteTrigger(conn, triggerName, groupName) > 0;
            if (null != job && !job.isDurable() && (numTriggers = this.getDelegate().selectNumTriggersForJob(conn, job.getName(), job.getGroup())) == 0) {
                this.removeJob(conn, ctxt, job.getName(), job.getGroup(), true);
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
        return removedTrigger;
    }

    protected boolean replaceTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        boolean removedTrigger = false;
        try {
            JobDetail job = this.getDelegate().selectJobForTrigger(conn, triggerName, groupName);
            if (job == null) {
                return false;
            }
            if (!newTrigger.getJobName().equals(job.getName()) || !newTrigger.getJobGroup().equals(job.getGroup())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            this.getDelegate().deleteSimpleTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteCronTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteBlobTrigger(conn, triggerName, groupName);
            this.getDelegate().deleteTriggerListeners(conn, triggerName, groupName);
            removedTrigger = this.getDelegate().deleteTrigger(conn, triggerName, groupName) > 0;
            this.storeTrigger(conn, ctxt, newTrigger, job, false, "WAITING", false, false);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove trigger: " + e.getMessage(), e);
        }
        return removedTrigger;
    }

    protected Trigger retrieveTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            Trigger trigger = this.getDelegate().selectTrigger(conn, triggerName, groupName);
            if (trigger == null) {
                return null;
            }
            String[] listeners = this.getDelegate().selectTriggerListeners(conn, triggerName, groupName);
            int i = 0;
            while (i < listeners.length) {
                trigger.addTriggerListener(listeners[i]);
                ++i;
            }
            return trigger;
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't retrieve trigger: " + e.getMessage(), e);
        }
    }

    public int getTriggerState(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            String ts = this.getDelegate().selectTriggerState(conn, triggerName, groupName);
            if (ts == null) {
                return -1;
            }
            if (ts.equals("DELETED")) {
                return -1;
            }
            if (ts.equals("COMPLETE")) {
                return 2;
            }
            if (ts.equals("PAUSED")) {
                return 1;
            }
            if (ts.equals("ERROR")) {
                return 3;
            }
            if (ts.equals("BLOCKED")) {
                return 4;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine state of trigger (" + groupName + "." + triggerName + "): " + e.getMessage(), e);
        }
    }

    protected void storeCalendar(Connection conn, SchedulingContext ctxt, String calName, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        try {
            boolean existingCal = this.calendarExists(conn, calName);
            if (existingCal && !replaceExisting) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + calName + "' already exists.");
            }
            if (existingCal) {
                if (this.getDelegate().updateCalendar(conn, calName, calendar) < 1) {
                    throw new JobPersistenceException("Couldn't store calendar.  Update failed.");
                }
                if (updateTriggers) {
                    Trigger[] trigs = this.getDelegate().selectTriggersForCalendar(conn, calName);
                    int i = 0;
                    while (i < trigs.length) {
                        trigs[i].updateWithNewCalendar(calendar, this.getMisfireThreshold());
                        this.storeTrigger(conn, ctxt, trigs[i], null, true, "WAITING", false, false);
                        ++i;
                    }
                }
            } else if (this.getDelegate().insertCalendar(conn, calName, calendar) < 1) {
                throw new JobPersistenceException("Couldn't store calendar.  Insert failed.");
            }
            this.calendarCache.put(calName, calendar);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't store calendar because the BLOB couldn't be serialized: " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't store calendar: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't store calendar: " + e.getMessage(), e);
        }
    }

    protected boolean calendarExists(Connection conn, String calName) throws JobPersistenceException {
        try {
            return this.getDelegate().calendarExists(conn, calName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine calendar existence (" + calName + "): " + e.getMessage(), e);
        }
    }

    protected boolean removeCalendar(Connection conn, SchedulingContext ctxt, String calName) throws JobPersistenceException {
        try {
            if (this.getDelegate().calendarIsReferenced(conn, calName)) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a trigger!");
            }
            this.calendarCache.remove(calName);
            return this.getDelegate().deleteCalendar(conn, calName) > 0;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't remove calendar: " + e.getMessage(), e);
        }
    }

    protected Calendar retrieveCalendar(Connection conn, SchedulingContext ctxt, String calName) throws JobPersistenceException {
        Calendar cal = (Calendar)this.calendarCache.get(calName);
        if (cal != null) {
            return cal;
        }
        try {
            cal = this.getDelegate().selectCalendar(conn, calName);
            this.calendarCache.put(calName, cal);
            return cal;
        }
        catch (ClassNotFoundException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar because a required class was not found: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar because the BLOB couldn't be deserialized: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't retrieve calendar: " + e.getMessage(), e);
        }
    }

    protected int getNumberOfJobs(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumJobs(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of jobs: " + e.getMessage(), e);
        }
    }

    protected int getNumberOfTriggers(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumTriggers(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of triggers: " + e.getMessage(), e);
        }
    }

    protected int getNumberOfCalendars(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectNumCalendars(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain number of calendars: " + e.getMessage(), e);
        }
    }

    protected String[] getJobNames(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] jobNames = null;
        try {
            jobNames = this.getDelegate().selectJobsInGroup(conn, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain job names: " + e.getMessage(), e);
        }
        return jobNames;
    }

    protected String[] getTriggerNames(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        String[] trigNames = null;
        try {
            trigNames = this.getDelegate().selectTriggersInGroup(conn, groupName);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger names: " + e.getMessage(), e);
        }
        return trigNames;
    }

    protected String[] getJobGroupNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] groupNames = null;
        try {
            groupNames = this.getDelegate().selectJobGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain job groups: " + e.getMessage(), e);
        }
        return groupNames;
    }

    protected String[] getTriggerGroupNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] groupNames = null;
        try {
            groupNames = this.getDelegate().selectTriggerGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + e.getMessage(), e);
        }
        return groupNames;
    }

    protected String[] getCalendarNames(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectCalendars(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't obtain trigger groups: " + e.getMessage(), e);
        }
    }

    protected Trigger[] getTriggersForJob(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        Trigger[] array = null;
        try {
            array = this.getDelegate().selectTriggersForJob(conn, jobName, groupName);
        }
        catch (Exception e) {
            throw new JobPersistenceException("Couldn't obtain triggers for job: " + e.getMessage(), e);
        }
        return array;
    }

    public void pauseTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            String oldState = this.getDelegate().selectTriggerState(conn, triggerName, groupName);
            if (oldState.equals("WAITING") || oldState.equals("BLOCKED") || oldState.equals("ACQUIRED")) {
                this.getDelegate().updateTriggerState(conn, triggerName, groupName, "PAUSED");
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    protected String getStatusForResumedTrigger(Connection conn, SchedulingContext ctxt, TriggerStatus status) throws JobPersistenceException {
        try {
            FiredTriggerRecord rec;
            String newState = "WAITING";
            List lst = this.getDelegate().selectFiredTriggerRecordsByJob(conn, status.getJobKey().getName(), status.getJobKey().getGroup());
            if (lst.size() > 0 && (rec = (FiredTriggerRecord)lst.get(0)).isJobIsStateful()) {
                newState = "BLOCKED";
            }
            return newState;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine new state in order to resume trigger '" + status.getKey().getGroup() + "." + status.getKey().getName() + "': " + e.getMessage(), e);
        }
    }

    protected String getNewStatusForTrigger(Connection conn, SchedulingContext ctxt, String jobName, String groupName) throws JobPersistenceException {
        try {
            FiredTriggerRecord rec;
            String newState = "WAITING";
            List lst = this.getDelegate().selectFiredTriggerRecordsByJob(conn, jobName, groupName);
            if (lst.size() > 0 && (rec = (FiredTriggerRecord)lst.get(0)).isJobIsStateful()) {
                newState = "BLOCKED";
            }
            return newState;
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine state for new trigger: " + e.getMessage(), e);
        }
    }

    public void resumeTrigger(Connection conn, SchedulingContext ctxt, String triggerName, String groupName) throws JobPersistenceException {
        try {
            TriggerStatus status = this.getDelegate().selectTriggerStatus(conn, triggerName, groupName);
            if (status == null || status.getNextFireTime() == null) {
                return;
            }
            String newState = this.getStatusForResumedTrigger(conn, ctxt, status);
            boolean misfired = false;
            if (status.getNextFireTime().before(new Date())) {
                misfired = this.updateMisfiredTrigger(conn, ctxt, triggerName, groupName, newState, true);
            }
            if (!misfired) {
                this.getDelegate().updateTriggerStateFromOtherState(conn, triggerName, groupName, newState, "PAUSED");
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't resume trigger '" + groupName + "." + triggerName + "': " + e.getMessage(), e);
        }
    }

    public void pauseTriggerGroup(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerGroupStateFromOtherStates(conn, groupName, "PAUSED", "ACQUIRED", "BLOCKED", "WAITING");
            if (!this.getDelegate().isTriggerGroupPaused(conn, groupName)) {
                this.getDelegate().insertPausedTriggerGroup(conn, groupName);
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupName + "': " + e.getMessage(), e);
        }
    }

    public Set getPausedTriggerGroups(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        try {
            return this.getDelegate().selectPausedTriggerGroups(conn);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't determine paused trigger groups: " + e.getMessage(), e);
        }
    }

    public void resumeTriggerGroup(Connection conn, SchedulingContext ctxt, String groupName) throws JobPersistenceException {
        try {
            this.getDelegate().deletePausedTriggerGroup(conn, groupName);
            String[] trigNames = this.getDelegate().selectTriggersInGroup(conn, groupName);
            int i = 0;
            while (i < trigNames.length) {
                this.resumeTrigger(conn, ctxt, trigNames[i], groupName);
                ++i;
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause trigger group '" + groupName + "': " + e.getMessage(), e);
        }
    }

    public void pauseAll(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] names = this.getTriggerGroupNames(conn, ctxt);
        int i = 0;
        while (i < names.length) {
            this.pauseTriggerGroup(conn, ctxt, names[i]);
            ++i;
        }
        try {
            if (!this.getDelegate().isTriggerGroupPaused(conn, "_$_ALL_GROUPS_PAUSED_$_")) {
                this.getDelegate().insertPausedTriggerGroup(conn, "_$_ALL_GROUPS_PAUSED_$_");
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't pause all trigger groups: " + e.getMessage(), e);
        }
    }

    public void resumeAll(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        String[] names = this.getTriggerGroupNames(conn, ctxt);
        int i = 0;
        while (i < names.length) {
            this.resumeTriggerGroup(conn, ctxt, names[i]);
            ++i;
        }
        try {
            this.getDelegate().deletePausedTriggerGroup(conn, "_$_ALL_GROUPS_PAUSED_$_");
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't resume all trigger groups: " + e.getMessage(), e);
        }
    }

    protected synchronized String getFiredTriggerRecordId() {
        return this.getInstanceId() + ftrCtr++;
    }

    protected Trigger acquireNextTrigger(Connection conn, SchedulingContext ctxt) throws JobPersistenceException {
        Trigger nextTrigger = null;
        boolean acquiredOne = false;
        do {
            try {
                this.getDelegate().updateTriggerStateFromOtherStatesBeforeTime(conn, "MISFIRED", "WAITING", "WAITING", this.getMisfireTime());
                long nextFireTime = this.getDelegate().selectNextFireTime(conn);
                if (nextFireTime == 0L) {
                    return null;
                }
                Key triggerKey = null;
                do {
                    int res;
                    if (null == (triggerKey = this.getDelegate().selectTriggerForFireTime(conn, nextFireTime)) || (res = this.getDelegate().updateTriggerStateFromOtherState(conn, triggerKey.getName(), triggerKey.getGroup(), "ACQUIRED", "WAITING")) <= 0 || (nextTrigger = this.retrieveTrigger(conn, ctxt, triggerKey.getName(), triggerKey.getGroup())) == null) continue;
                    nextTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
                    this.getDelegate().insertFiredTrigger(conn, nextTrigger, "ACQUIRED", null);
                    acquiredOne = true;
                } while (triggerKey != null && !acquiredOne);
            }
            catch (Exception e) {
                throw new JobPersistenceException("Couldn't acquire next trigger: " + e.getMessage(), e);
            }
        } while (!acquiredOne);
        return nextTrigger;
    }

    protected void releaseAcquiredTrigger(Connection conn, SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        try {
            this.getDelegate().updateTriggerStateFromOtherState(conn, trigger.getName(), trigger.getGroup(), "WAITING", "ACQUIRED");
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't release acquired trigger: " + e.getMessage(), e);
        }
    }

    protected TriggerFiredBundle triggerFired(Connection conn, SchedulingContext ctxt, Trigger trigger) throws JobPersistenceException {
        JobDetail job = null;
        Calendar cal = null;
        try {
            String state = this.getDelegate().selectTriggerState(conn, trigger.getName(), trigger.getGroup());
            if (!state.equals("ACQUIRED")) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't select trigger state: " + e.getMessage(), e);
        }
        try {
            job = this.retrieveJob(conn, ctxt, trigger.getJobName(), trigger.getJobGroup());
            if (job == null) {
                return null;
            }
        }
        catch (JobPersistenceException jpe) {
            try {
                this.getDelegate().updateTriggerState(conn, trigger.getName(), trigger.getGroup(), "ERROR");
            }
            catch (SQLException sqle) {
                this.getLog().error((Object)"Unable to set trigger state to ERROR.", (Throwable)sqle);
            }
            throw jpe;
        }
        if (trigger.getCalendarName() != null && (cal = this.retrieveCalendar(conn, ctxt, trigger.getCalendarName())) == null) {
            return null;
        }
        try {
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
            this.getDelegate().insertFiredTrigger(conn, trigger, "EXECUTING", job);
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't insert fired trigger: " + e.getMessage(), e);
        }
        Date prevFireTime = trigger.getPreviousFireTime();
        trigger.triggered(cal);
        String state = "WAITING";
        boolean force = true;
        if (job.isStateful()) {
            state = "BLOCKED";
            force = false;
            try {
                this.getDelegate().updateTriggerStatesForJob(conn, job.getName(), job.getGroup(), "BLOCKED");
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't update states of blocked triggers: " + e.getMessage(), e);
            }
        }
        if (trigger.getNextFireTime() == null) {
            state = "COMPLETE";
            force = true;
        }
        this.storeTrigger(conn, ctxt, trigger, job, true, state, force, false);
        job.getJobDataMap().clearDirtyFlag();
        return new TriggerFiredBundle(job, trigger, cal, trigger.getGroup().equals("RECOVERING_JOBS"), new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
    }

    protected void triggeredJobComplete(Connection conn, SchedulingContext ctxt, Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        block14: {
            try {
                if (triggerInstCode == 3) {
                    TriggerStatus stat;
                    if (trigger.getNextFireTime() == null && (stat = this.getDelegate().selectTriggerStatus(conn, trigger.getName(), trigger.getGroup())) != null && stat.getNextFireTime() == null) {
                        this.removeTrigger(conn, ctxt, trigger.getName(), trigger.getGroup());
                    }
                    this.removeTrigger(conn, ctxt, trigger.getName(), trigger.getGroup());
                } else if (triggerInstCode == 2) {
                    this.getDelegate().updateTriggerState(conn, trigger.getName(), trigger.getGroup(), "COMPLETE");
                } else if (triggerInstCode == 4) {
                    this.getDelegate().updateTriggerStatesForJob(conn, trigger.getJobName(), trigger.getJobGroup(), "COMPLETE");
                }
                if (!jobDetail.isStateful()) break block14;
                this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jobDetail.getName(), jobDetail.getGroup(), "WAITING", "BLOCKED");
                try {
                    if (jobDetail.getJobDataMap().isDirty()) {
                        this.getDelegate().updateJobData(conn, jobDetail);
                    }
                }
                catch (IOException e) {
                    throw new JobPersistenceException("Couldn't serialize job data: " + e.getMessage(), e);
                }
                catch (SQLException e) {
                    throw new JobPersistenceException("Couldn't update job data: " + e.getMessage(), e);
                }
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't update trigger state(s): " + e.getMessage(), e);
            }
        }
        try {
            this.getDelegate().deleteFiredTrigger(conn, trigger.getFireInstanceId());
        }
        catch (SQLException e) {
            throw new JobPersistenceException("Couldn't delete fired trigger: " + e.getMessage(), e);
        }
    }

    protected DriverDelegate getDelegate() throws NoSuchDelegateException {
        if (null == this.delegate) {
            try {
                Constructor ctor = null;
                Object[] ctorParams = null;
                if (this.canUseProperties()) {
                    Class[] ctorParamTypes = new Class[]{class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = JobStoreSupport.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = JobStoreSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean};
                    ctor = this.delegateClass.getConstructor(ctorParamTypes);
                    ctorParams = new Object[]{this.getLog(), this.tablePrefix, this.instanceId, new Boolean(this.canUseProperties())};
                } else {
                    Class[] ctorParamTypes = new Class[]{class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = JobStoreSupport.class$("org.apache.commons.logging.Log")) : class$org$apache$commons$logging$Log, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = JobStoreSupport.class$("java.lang.String")) : class$java$lang$String};
                    ctor = this.delegateClass.getConstructor(ctorParamTypes);
                    ctorParams = new Object[]{this.getLog(), this.tablePrefix, this.instanceId};
                }
                this.delegate = (DriverDelegate)ctor.newInstance(ctorParams);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchDelegateException("Couldn't find delegate constructor: " + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage());
            }
        }
        return this.delegate;
    }

    protected Semaphore getLockHandler() {
        return this.lockHandler;
    }

    protected abstract boolean doRecoverMisfires() throws JobPersistenceException;

    protected void signalSchedulingChange() {
        this.signaler.signalSchedulingChange();
    }

    protected abstract boolean doCheckin() throws JobPersistenceException;

    protected List clusterCheckIn(Connection conn) throws JobPersistenceException {
        List states = null;
        LinkedList<SchedulerStateRecord> failedInstances = new LinkedList<SchedulerStateRecord>();
        SchedulerStateRecord myLastState = null;
        boolean selfFailed = false;
        long timeNow = System.currentTimeMillis();
        try {
            states = this.getDelegate().selectSchedulerStateRecords(conn, null);
            Iterator itr = states.iterator();
            while (itr.hasNext()) {
                SchedulerStateRecord rec = (SchedulerStateRecord)itr.next();
                if (rec.getSchedulerInstanceId().equals(this.getInstanceId())) {
                    myLastState = rec;
                    if (rec.getRecoverer() != null && !this.firstCheckIn) {
                        selfFailed = true;
                    }
                    if (rec.getRecoverer() != null || !this.firstCheckIn) continue;
                    failedInstances.add(rec);
                    continue;
                }
                long failedIfAfter = rec.getCheckinTimestamp() + (rec.getCheckinInterval() + 7500L);
                if (failedIfAfter >= timeNow || rec.getRecoverer() != null || rec.getSchedulerInstanceId().equals(this.getInstanceId())) continue;
                failedInstances.add(rec);
            }
            this.getDelegate().deleteSchedulerState(conn, this.getInstanceId());
            this.lastCheckin = System.currentTimeMillis();
            this.getDelegate().insertSchedulerState(conn, this.getInstanceId(), this.lastCheckin, this.getClusterCheckinInterval(), null);
        }
        catch (Exception e) {
            this.lastCheckin = System.currentTimeMillis();
            throw new JobPersistenceException("Failure checking-in: " + e.getMessage(), e);
        }
        return failedInstances;
    }

    protected void clusterRecover(Connection conn, List failedInstances) throws JobPersistenceException {
        if (failedInstances.size() > 0) {
            long recoverIds = System.currentTimeMillis();
            this.logWarnIfNonZero(failedInstances.size(), "ClusterManager: detected " + failedInstances.size() + " failed instances.");
            try {
                Iterator itr = failedInstances.iterator();
                while (itr.hasNext()) {
                    SchedulerStateRecord rec = (SchedulerStateRecord)itr.next();
                    this.getLog().info((Object)("ClusterManager: Scanning for instance \"" + rec.getSchedulerInstanceId() + "\"'s failed in-progress jobs."));
                    List firedTriggerRecs = this.getDelegate().selectInstancesFiredTriggerRecords(conn, rec.getSchedulerInstanceId());
                    int acquiredCount = 0;
                    int recoveredCount = 0;
                    int otherCount = 0;
                    Iterator ftItr = firedTriggerRecs.iterator();
                    while (ftItr.hasNext()) {
                        FiredTriggerRecord ftRec = (FiredTriggerRecord)ftItr.next();
                        Key tKey = ftRec.getTriggerKey();
                        Key jKey = ftRec.getJobKey();
                        if (ftRec.getFireInstanceState().equals("BLOCKED")) {
                            this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "WAITING", "BLOCKED");
                        }
                        if (ftRec.getFireInstanceState().equals("ACQUIRED")) {
                            this.getDelegate().updateTriggerStateFromOtherState(conn, tKey.getName(), tKey.getGroup(), "WAITING", "ACQUIRED");
                            ++acquiredCount;
                        } else if (ftRec.isJobRequestsRecovery()) {
                            if (this.jobExists(conn, jKey.getName(), jKey.getGroup())) {
                                SimpleTrigger rcvryTrig = new SimpleTrigger("recover_" + rec.getSchedulerInstanceId() + "_" + String.valueOf(recoverIds++), "RECOVERING_JOBS", new Date(ftRec.getFireTimestamp()));
                                rcvryTrig.setJobName(jKey.getName());
                                rcvryTrig.setJobGroup(jKey.getGroup());
                                rcvryTrig.setMisfireInstruction(1);
                                rcvryTrig.computeFirstFireTime(null);
                                this.storeTrigger(conn, null, rcvryTrig, null, false, "WAITING", false, true);
                                ++recoveredCount;
                            } else {
                                this.getLog().warn((Object)("ClusterManager: failed job '" + jKey + "' no longer exists, cannot schedule recovery."));
                                ++otherCount;
                            }
                        } else {
                            ++otherCount;
                        }
                        if (!ftRec.isJobIsStateful()) continue;
                        this.getDelegate().updateTriggerStatesForJobFromOtherState(conn, jKey.getName(), jKey.getGroup(), "WAITING", "BLOCKED");
                    }
                    this.getDelegate().deleteFiredTriggers(conn, rec.getSchedulerInstanceId());
                    this.logWarnIfNonZero(acquiredCount, "ClusterManager: ......Freed " + acquiredCount + " acquired trigger(s).");
                    this.logWarnIfNonZero(recoveredCount, "ClusterManager: ......Scheduled " + recoveredCount + " recoverable job(s) for recovery.");
                    this.logWarnIfNonZero(otherCount, "ClusterManager: ......Cleaned-up " + otherCount + " other failed job(s).");
                    this.getDelegate().deleteSchedulerState(conn, rec.getSchedulerInstanceId());
                    String recoverer = this.getInstanceId();
                    long checkInTS = rec.getCheckinTimestamp();
                    if (rec.getSchedulerInstanceId().equals(this.getInstanceId())) {
                        recoverer = null;
                        checkInTS = System.currentTimeMillis();
                    }
                    this.getDelegate().insertSchedulerState(conn, rec.getSchedulerInstanceId(), checkInTS, rec.getCheckinInterval(), recoverer);
                }
            }
            catch (Exception e) {
                throw new JobPersistenceException("Failure recovering jobs: " + e.getMessage(), e);
            }
        }
    }

    protected void logWarnIfNonZero(int val, String warning) {
        if (val > 0) {
            this.getLog().info((Object)warning);
        } else {
            this.getLog().debug((Object)warning);
        }
    }

    protected void closeConnection(Connection conn) throws JobPersistenceException {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't close jdbc connection. " + e.getMessage(), e);
            }
        }
    }

    protected void rollbackConnection(Connection conn) throws JobPersistenceException {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't rollback jdbc connection. " + e.getMessage(), e);
            }
        }
    }

    protected void commitConnection(Connection conn) throws JobPersistenceException {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new JobPersistenceException("Couldn't commit jdbc connection. " + e.getMessage(), e);
            }
        }
    }

    public abstract void triggeredJobComplete(SchedulingContext var1, Trigger var2, JobDetail var3, int var4) throws JobPersistenceException;

    public abstract TriggerFiredBundle triggerFired(SchedulingContext var1, Trigger var2) throws JobPersistenceException;

    public abstract void releaseAcquiredTrigger(SchedulingContext var1, Trigger var2) throws JobPersistenceException;

    public abstract Trigger acquireNextTrigger(SchedulingContext var1) throws JobPersistenceException;

    public abstract void resumeAll(SchedulingContext var1) throws JobPersistenceException;

    public abstract void pauseAll(SchedulingContext var1) throws JobPersistenceException;

    public abstract void resumeJobGroup(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract void resumeJob(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract Set getPausedTriggerGroups(SchedulingContext var1) throws JobPersistenceException;

    public abstract void resumeTriggerGroup(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract void resumeTrigger(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract void pauseJobGroup(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract void pauseJob(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract void pauseTriggerGroup(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract void pauseTrigger(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract int getTriggerState(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract Trigger[] getTriggersForJob(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract String[] getCalendarNames(SchedulingContext var1) throws JobPersistenceException;

    public abstract String[] getTriggerGroupNames(SchedulingContext var1) throws JobPersistenceException;

    public abstract String[] getJobGroupNames(SchedulingContext var1) throws JobPersistenceException;

    public abstract String[] getTriggerNames(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract String[] getJobNames(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract int getNumberOfCalendars(SchedulingContext var1) throws JobPersistenceException;

    public abstract int getNumberOfTriggers(SchedulingContext var1) throws JobPersistenceException;

    public abstract int getNumberOfJobs(SchedulingContext var1) throws JobPersistenceException;

    public abstract Calendar retrieveCalendar(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract boolean removeCalendar(SchedulingContext var1, String var2) throws JobPersistenceException;

    public abstract void storeCalendar(SchedulingContext var1, String var2, Calendar var3, boolean var4, boolean var5) throws ObjectAlreadyExistsException, JobPersistenceException;

    public abstract Trigger retrieveTrigger(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract boolean replaceTrigger(SchedulingContext var1, String var2, String var3, Trigger var4) throws JobPersistenceException;

    public abstract boolean removeTrigger(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract void storeTrigger(SchedulingContext var1, Trigger var2, boolean var3) throws ObjectAlreadyExistsException, JobPersistenceException;

    public abstract JobDetail retrieveJob(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract boolean removeJob(SchedulingContext var1, String var2, String var3) throws JobPersistenceException;

    public abstract void storeJob(SchedulingContext var1, JobDetail var2, boolean var3) throws ObjectAlreadyExistsException, JobPersistenceException;

    public abstract void storeJobAndTrigger(SchedulingContext var1, JobDetail var2, Trigger var3) throws ObjectAlreadyExistsException, JobPersistenceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MisfireHandler
    extends Thread {
        private boolean shutdown = false;
        private JobStoreSupport js;
        private int numFails = 0;

        MisfireHandler(JobStoreSupport js) {
            this.js = js;
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_MisfireHandler");
        }

        public void initialize() {
            this.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private boolean manage() {
            try {
                JobStoreSupport.this.getLog().debug((Object)"MisfireHandler: scanning for misfires...");
                boolean res = this.js.doRecoverMisfires();
                this.numFails = 0;
                return res;
            }
            catch (Exception e) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error((Object)("MisfireHandler: Error handling misfires: " + e.getMessage()), (Throwable)e);
                }
                ++this.numFails;
                return false;
            }
        }

        public void run() {
            while (!this.shutdown) {
                long sTime = System.currentTimeMillis();
                boolean moreToDo = this.manage();
                if (JobStoreSupport.this.lastRecoverCount > 0) {
                    JobStoreSupport.this.signalSchedulingChange();
                }
                long spanTime = System.currentTimeMillis() - sTime;
                if (!this.shutdown && !moreToDo) {
                    long timeToSleep = JobStoreSupport.this.getMisfireThreshold() - spanTime;
                    if (timeToSleep <= 0L) {
                        timeToSleep = 50L;
                    }
                    if (this.numFails > 0) {
                        timeToSleep = Math.max(JobStoreSupport.this.getDbRetryInterval(), timeToSleep);
                    }
                    if (timeToSleep <= 0L) continue;
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (Exception ignore) {}
                    continue;
                }
                if (!moreToDo) continue;
                try {
                    Thread.sleep(50L);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    class ClusterManager
    extends Thread {
        private boolean shutdown = false;
        private JobStoreSupport js;
        private int numFails = 0;

        ClusterManager(JobStoreSupport js) {
            this.js = js;
            this.setName("QuartzScheduler_" + JobStoreSupport.this.instanceName + "-" + JobStoreSupport.this.instanceId + "_ClusterManager");
        }

        public void initialize() {
            this.manage();
            this.start();
        }

        public void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        private boolean manage() {
            boolean res = false;
            try {
                res = this.js.doCheckin();
                this.numFails = 0;
                JobStoreSupport.this.getLog().debug((Object)"ClusterManager: Check-in complete.");
            }
            catch (Exception e) {
                if (this.numFails % 4 == 0) {
                    JobStoreSupport.this.getLog().error((Object)("ClusterManager: Error managing cluster: " + e.getMessage()), (Throwable)e);
                }
                ++this.numFails;
            }
            return res;
        }

        public void run() {
            while (!this.shutdown) {
                if (!this.shutdown) {
                    long timeToSleep = JobStoreSupport.this.getClusterCheckinInterval();
                    long transpiredTime = System.currentTimeMillis() - JobStoreSupport.this.lastCheckin;
                    if ((timeToSleep -= transpiredTime) <= 0L) {
                        timeToSleep = 100L;
                    }
                    if (this.numFails > 0) {
                        timeToSleep = Math.max(JobStoreSupport.this.getDbRetryInterval(), timeToSleep);
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (!this.manage()) continue;
                JobStoreSupport.this.signalSchedulingChange();
            }
        }
    }
}

