/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexDiff;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMDirectory;

public class DiffDirectory
extends Directory {
    private Directory backingDirectory;
    private IndexDiff indexDiff;

    public DiffDirectory() {
        this.backingDirectory = new RAMDirectory();
        this.indexDiff = new IndexDiff(null);
    }

    public DiffDirectory(File f, boolean create) throws IOException {
        FSDirectory fsd = FSDirectory.getDirectory((File)f, (boolean)create);
        this.backingDirectory = fsd;
        this.indexDiff = new IndexDiff(f);
        if (fsd.list().length > 0) {
            this.indexDiff.readSegmentInfos((Directory)fsd);
        }
    }

    public DiffDirectory(Directory backingDirectory) throws IOException {
        this.backingDirectory = backingDirectory;
        if (backingDirectory instanceof FSDirectory) {
            FSDirectory fsd = (FSDirectory)backingDirectory;
            this.indexDiff = new IndexDiff(fsd.getFile());
            if (fsd.list().length > 0) {
                this.indexDiff.readSegmentInfos((Directory)fsd);
            }
        }
    }

    public String[] list() throws IOException {
        return this.backingDirectory.list();
    }

    public boolean fileExists(String name) throws IOException {
        return this.backingDirectory.fileExists(name);
    }

    public long fileModified(String name) throws IOException {
        return this.backingDirectory.fileModified(name);
    }

    public void touchFile(String name) throws IOException {
        this.backingDirectory.touchFile(name);
    }

    public long fileLength(String name) throws IOException {
        return this.backingDirectory.fileLength(name);
    }

    public void deleteFile(String name) throws IOException {
        if (name.indexOf(".frq") > -1) {
            this.indexDiff.addDeletedSegment(name.substring(0, name.length() - 4));
        }
        this.backingDirectory.deleteFile(name);
    }

    public void renameFile(String from, String to) throws IOException {
        this.backingDirectory.renameFile(from, to);
        if (to.indexOf(".del") > -1) {
            this.indexDiff.addSegmentDelFile(to);
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        if (name.indexOf(".frq") > -1) {
            this.indexDiff.addNewSegment(name.substring(0, name.length() - 4));
        }
        return this.backingDirectory.createOutput(name);
    }

    public IndexInput openInput(String name) throws IOException {
        if ("segments".equals(name)) {
            this.indexDiff.readSegmentInfos(this.backingDirectory);
        }
        return this.backingDirectory.openInput(name);
    }

    public Lock makeLock(String name) {
        return this.backingDirectory.makeLock(name);
    }

    public void close() throws IOException {
        this.backingDirectory.close();
    }

    public IndexDiff getIndexDiff() {
        return this.indexDiff;
    }
}

