/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexDiff {
    private Set deletedSegments = new HashSet();
    private Set addedSegments = new HashSet();
    private Set segmentDelFiles = new HashSet();
    private SegmentInfos infos;
    private Set originalSegmentNames = new HashSet();
    private File index;

    public IndexDiff(Set deletedSegments, Set addedSegments, Set segmentDelFiles, SegmentInfos infos, Set originalSegmentNames, File index) {
        this.deletedSegments = deletedSegments;
        this.addedSegments = addedSegments;
        this.segmentDelFiles = segmentDelFiles;
        this.infos = infos;
        this.originalSegmentNames = originalSegmentNames;
        this.index = index;
    }

    public IndexDiff(File index) {
        this.index = index;
    }

    public synchronized void addDeletedSegment(String name) {
        this.addedSegments.remove(name);
        if (this.originalSegmentNames.contains(name)) {
            this.deletedSegments.add(name);
        }
    }

    public synchronized void addNewSegment(String segmentName) {
        this.addedSegments.add(segmentName);
    }

    public synchronized void addSegmentDelFile(String file) {
        this.segmentDelFiles.add(file);
    }

    public void readSegmentInfos(Directory directory) throws IOException {
        if (this.infos != null) {
            return;
        }
        this.infos = new SegmentInfos();
        this.infos.read(directory);
        for (int i = 0; i < this.infos.size(); ++i) {
            SegmentInfo si = this.infos.info(i);
            this.originalSegmentNames.add(si.name);
        }
    }

    public void write(String zipfile) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipfile));
        Iterator it = this.deletedSegments.iterator();
        while (it.hasNext()) {
            String deleted = (String)it.next();
            zos.putNextEntry(new ZipEntry("deleted/" + deleted));
            zos.closeEntry();
        }
        it = this.segmentDelFiles.iterator();
        while (it.hasNext()) {
            String segdel = (String)it.next();
            zos.putNextEntry(new ZipEntry("segdel/" + segdel));
            FileInputStream fis = new FileInputStream(new File(this.index, segdel));
            IndexDiff.transfer(fis, zos);
            fis.close();
            zos.closeEntry();
        }
        it = this.addedSegments.iterator();
        while (it.hasNext()) {
            String segmentname = (String)it.next();
            File[] indexfiles = this.index.listFiles();
            for (int i = 0; i < indexfiles.length; ++i) {
                if (!indexfiles[i].getName().startsWith(segmentname)) continue;
                zos.putNextEntry(new ZipEntry("added/" + indexfiles[i].getName()));
                FileInputStream fis = new FileInputStream(indexfiles[i]);
                IndexDiff.transfer(fis, zos);
                fis.close();
                zos.closeEntry();
            }
        }
        zos.putNextEntry(new ZipEntry("segments/segments"));
        FileInputStream fis = new FileInputStream(new File(this.index, "segments"));
        IndexDiff.transfer(fis, zos);
        fis.close();
        zos.closeEntry();
        zos.close();
    }

    public String toString() {
        return "IndexDiff{deletedSegments=" + this.deletedSegments + ", addedSegments=" + this.addedSegments + ", segmentDelFiles=" + this.segmentDelFiles + ", infos=" + this.infos + ", originalSegmentNames=" + this.originalSegmentNames + ", index=" + this.index + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexDiff indexDiff = (IndexDiff)o;
        if (!((Object)this.addedSegments).equals(indexDiff.addedSegments)) {
            return false;
        }
        if (!((Object)this.deletedSegments).equals(indexDiff.deletedSegments)) {
            return false;
        }
        if (!this.index.equals(indexDiff.index)) {
            return false;
        }
        return ((Object)this.segmentDelFiles).equals(indexDiff.segmentDelFiles);
    }

    public int hashCode() {
        int result = ((Object)this.deletedSegments).hashCode();
        result = 29 * result + ((Object)this.addedSegments).hashCode();
        result = 29 * result + ((Object)this.segmentDelFiles).hashCode();
        result = 29 * result + ((Object)this.originalSegmentNames).hashCode();
        result = 29 * result + this.index.hashCode();
        return result;
    }

    private static final void transfer(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
    }

    public static IndexDiff createDiff(File oldIndex, File newIndex) throws IOException {
        String segmentname;
        SegmentInfos oldinfos = new SegmentInfos();
        oldinfos.read((Directory)FSDirectory.getDirectory((File)oldIndex, (boolean)false));
        SegmentInfos newinfos = new SegmentInfos();
        newinfos.read((Directory)FSDirectory.getDirectory((File)newIndex, (boolean)false));
        HashSet<String> newSegmentNames = new HashSet<String>();
        HashSet<String> oldSegmentNames = new HashSet<String>();
        HashSet<String> deletedSegmentNames = new HashSet<String>();
        HashSet<String> addedSegmentNames = new HashSet<String>();
        Iterator it = newinfos.iterator();
        while (it.hasNext()) {
            newSegmentNames.add(((SegmentInfo)it.next()).name);
        }
        it = oldinfos.iterator();
        while (it.hasNext()) {
            segmentname = ((SegmentInfo)it.next()).name;
            oldSegmentNames.add(segmentname);
            if (newSegmentNames.contains(segmentname)) continue;
            deletedSegmentNames.add(segmentname);
        }
        it = newSegmentNames.iterator();
        while (it.hasNext()) {
            segmentname = (String)it.next();
            if (oldSegmentNames.contains(segmentname)) continue;
            addedSegmentNames.add(segmentname);
        }
        HashSet<String> newSegmentDels = new HashSet<String>();
        File[] newdels = newIndex.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".del");
            }
        });
        for (int i = 0; i < newdels.length; ++i) {
            if (new File(oldIndex, newdels[i].getName()).exists()) continue;
            newSegmentDels.add(newdels[i].getName());
        }
        return new IndexDiff(deletedSegmentNames, addedSegmentNames, newSegmentDels, newinfos, newSegmentNames, newIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patch(File index, String zipfile) throws IOException {
        LinkedList<String> deleteables = new LinkedList<String>();
        ZipFile zipFile = new ZipFile(zipfile);
        File[] indexfiles = index.listFiles();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String[] split = entry.getName().split("/");
            String inDirectory = split[0];
            String entryName = split[1];
            if (inDirectory.equals("deleted")) {
                for (int i = 0; i < indexfiles.length; ++i) {
                    if (!indexfiles[i].getName().startsWith(entryName) || indexfiles[i].delete()) continue;
                    deleteables.add(indexfiles[i].getName());
                }
                continue;
            }
            File f = new File(index, entryName);
            if (f.exists()) {
                f.delete();
            }
            FileOutputStream out = new FileOutputStream(f);
            IndexDiff.transfer(zipFile.getInputStream(entry), out);
            out.close();
        }
        if (deleteables.size() > 0) {
            FSDirectory directory = FSDirectory.getDirectory((File)index, (boolean)false);
            org.apache.lucene.store.OutputStream output = directory.createFile("deleteable.new");
            try {
                output.writeInt(deleteables.size());
                Iterator it = deleteables.iterator();
                while (it.hasNext()) {
                    output.writeString((String)it.next());
                }
            }
            finally {
                output.close();
            }
            directory.renameFile("deleteable.new", "deletable");
        }
    }

    public static void main(String[] args) throws IOException {
        String zipfile = null;
        String oldindex = null;
        String newindex = null;
        boolean patch = false;
        boolean create = false;
        if (args.length == 0) {
            IndexDiff.printUsage();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.equals("-zip")) {
                zipfile = args[++i].trim();
                continue;
            }
            if (arg.equals("-old")) {
                oldindex = args[++i].trim();
                continue;
            }
            if (arg.equals("-new")) {
                newindex = args[++i].trim();
                continue;
            }
            if (arg.equals("-create")) {
                create = true;
                continue;
            }
            if (!arg.equals("-patch")) continue;
            patch = true;
        }
        if (patch) {
            if (oldindex != null && zipfile != null) {
                IndexDiff.patch(new File(oldindex), zipfile);
            } else {
                IndexDiff.printUsage();
            }
        } else if (create) {
            if (oldindex != null && newindex != null && zipfile != null) {
                IndexDiff id = IndexDiff.createDiff(new File(oldindex), new File(newindex));
                id.write(zipfile);
            } else {
                IndexDiff.printUsage();
            }
        } else {
            IndexDiff.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: IndexDiff -(patch|create) -old <oldindex> -new <newindex> -zip <zipfile>");
        System.exit(0);
    }
}

