/*
 * Decompiled with CFR 0.152.
 */
package bucket.util.longrunning;

import bucket.util.longrunning.LongRunningTask;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.ProgressMeter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Category;

public abstract class AbstractLongRunningTask
implements LongRunningTask {
    public static final Category log = Category.getInstance((Class)(class$bucket$util$longrunning$AbstractLongRunningTask == null ? (class$bucket$util$longrunning$AbstractLongRunningTask = AbstractLongRunningTask.class$("bucket.util.longrunning.AbstractLongRunningTask")) : class$bucket$util$longrunning$AbstractLongRunningTask));
    long startTime = System.currentTimeMillis();
    protected ProgressMeter progress = new ProgressMeter();
    static /* synthetic */ Class class$bucket$util$longrunning$AbstractLongRunningTask;

    protected AbstractLongRunningTask() {
        this.progress.setStatus("Initializing... ");
    }

    public void run() {
        this.progress.setStatus("Starting... ");
        this.startTime = System.currentTimeMillis();
    }

    public int getPercentageComplete() {
        return this.progress.getPercentageComplete();
    }

    public String getCurrentStatus() {
        return this.progress.getStatus();
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getEstimatedTimeRemaining() {
        long elapsedTime = this.getElapsedTime();
        if (this.getPercentageComplete() == 0) {
            return 0L;
        }
        long totalTimeEstimate = 100L * elapsedTime / (long)this.getPercentageComplete();
        return totalTimeEstimate - elapsedTime;
    }

    public boolean isComplete() {
        return this.getPercentageComplete() == 100;
    }

    public String getPrettyElapsedTime() {
        return this.prettyTime(this.getElapsedTime());
    }

    protected abstract ResourceBundle getResourceBundle();

    private String prettyTime(long time) {
        if (time < 1000L) {
            return "Less than a second";
        }
        if (time / 1000L < 60L) {
            return time / 1000L + " seconds";
        }
        String minutesAndAbove = null;
        try {
            minutesAndAbove = DateUtils.getDurationPretty((long)(time / 1000L), (ResourceBundle)this.getResourceBundle());
        }
        catch (MissingResourceException e) {
            log.error((Object)"Could not load resourcebundle for 'minute'!'", (Throwable)e);
        }
        long secondsRemainder = time / 1000L % 60L;
        if (secondsRemainder > 0L) {
            minutesAndAbove = minutesAndAbove + ", " + secondsRemainder + " second" + (secondsRemainder == 1L ? "" : "s");
        }
        return minutesAndAbove;
    }

    public String getPrettyTimeRemaining() {
        long estimatedTimeRemaining = this.getEstimatedTimeRemaining();
        if (estimatedTimeRemaining == 0L) {
            return "Unknown";
        }
        return this.prettyTime(estimatedTimeRemaining);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

