/*
 * Decompiled with CFR 0.152.
 */
package bucket.util;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResettableIncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)(class$bucket$util$ResettableIncrementGenerator == null ? (class$bucket$util$ResettableIncrementGenerator = ResettableIncrementGenerator.class$("bucket.util.ResettableIncrementGenerator")) : class$bucket$util$ResettableIncrementGenerator));
    private long next;
    private String sql;
    private Class returnClass;
    private String origSql;
    static /* synthetic */ Class class$bucket$util$ResettableIncrementGenerator;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;

    public synchronized Serializable generate(SessionImplementor session, Object object) throws SQLException, HibernateException {
        if (this.sql != null) {
            this.getNext(session.connection());
        }
        return ResettableIncrementGenerator.createNumber(this.next++, this.returnClass);
    }

    public synchronized void reset() {
        this.sql = this.origSql;
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        String column;
        String table = params.getProperty("table");
        if (table == null) {
            table = params.getProperty("target_table");
        }
        if ((column = params.getProperty("column")) == null) {
            column = params.getProperty("target_column");
        }
        String schema = params.getProperty("schema");
        this.returnClass = type.getReturnedClass();
        this.origSql = this.sql = "select max(" + column + ") from " + (schema == null ? table : schema + '.' + table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getNext(Connection conn) throws SQLException {
        PreparedStatement st;
        block6: {
            log.debug((Object)("fetching initial value: " + this.sql));
            st = conn.prepareStatement(this.sql);
            ResultSet rs = null;
            try {
                rs = st.executeQuery();
                if (rs.next()) {
                    this.next = rs.getLong(1) + 1L;
                    if (rs.wasNull()) {
                        this.next = 1L;
                    }
                } else {
                    this.next = 1L;
                }
                this.sql = null;
                log.debug((Object)("first free id: " + this.next));
                Object var5_4 = null;
                if (rs == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (rs != null) {
                    rs.close();
                }
                st.close();
                throw throwable;
            }
            rs.close();
        }
        st.close();
    }

    static Number createNumber(long value, Class clazz) throws IdentifierGenerationException {
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ResettableIncrementGenerator.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(value);
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ResettableIncrementGenerator.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)value);
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ResettableIncrementGenerator.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)value);
        }
        throw new IdentifierGenerationException("this id generator generates long, integer, short");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

