/*
 * Decompiled with CFR 0.152.
 */
package bucket.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.zip.FolderArchiver;
import com.opensymphony.util.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    private static Log log = LogFactory.getLog((Class)(class$bucket$util$FileUtils == null ? (class$bucket$util$FileUtils = FileUtils.class$("bucket.util.FileUtils")) : class$bucket$util$FileUtils));
    private static final int BUFFER_SIZE = 1024;
    static /* synthetic */ Class class$bucket$util$FileUtils;

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory(srcDir, destDir, false);
    }

    public static void copyDirectory(File srcDir, File destDir, boolean overwrite) throws IOException {
        File[] files = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        } else {
            log.debug((Object)(destDir.getAbsolutePath() + " already exists"));
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                File dest = new File(destDir, file.getName());
                if (file.isFile()) {
                    FileUtils.copyFile(new FileInputStream(file), dest, overwrite);
                    continue;
                }
                FileUtils.copyDirectory(file, dest, overwrite);
            }
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream input = new FileInputStream(srcFile);
        FileUtils.copyFile(input, destFile);
    }

    public static void copyFile(InputStream srcStream, File destFile) throws IOException {
        FileUtils.copyFile(srcStream, destFile, false);
    }

    public static void copyFile(InputStream srcStream, File destFile, boolean overwrite) throws IOException {
        File parentFile = destFile.getParentFile();
        if (!parentFile.isDirectory()) {
            parentFile.mkdirs();
        }
        if (destFile.exists()) {
            if (overwrite) {
                log.debug((Object)("Overwriting file at: " + destFile.getAbsolutePath()));
                FileUtils.writeStreamToFile(srcStream, destFile);
            } else {
                try {
                    if (srcStream != null) {
                        srcStream.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                log.warn((Object)(destFile.getAbsolutePath() + " already exists"));
            }
        } else {
            destFile.createNewFile();
            FileUtils.writeStreamToFile(srcStream, destFile);
        }
    }

    private static void writeStreamToFile(InputStream srcStream, File destFile) throws IOException {
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            int ch;
            input = new BufferedInputStream(srcStream);
            output = new BufferedOutputStream(new FileOutputStream(destFile));
            while ((ch = ((InputStream)input).read()) != -1) {
                output.write(ch);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error writing stream to file: " + destFile.getAbsolutePath()));
            throw e;
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {}
            try {
                output.close();
            }
            catch (IOException e) {}
        }
    }

    public static void saveTextFile(String stringContent, File destFile) throws IOException {
        FileUtils.ensureFileAndPathExist(destFile);
        FileWriter writer = new FileWriter(destFile);
        writer.write(stringContent);
        writer.close();
    }

    public static void ensureFileAndPathExist(File file) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
    }

    public static void createZipFile(File baseDir, File zipFile) throws Exception {
        FolderArchiver compressor = new FolderArchiver(baseDir, zipFile);
        compressor.doArchive();
    }

    public static List readResourcesAsList(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String s;
            InputStream is = ClassLoaderUtils.getResourceAsStream((String)resource, (Class)(class$bucket$util$FileUtils == null ? (class$bucket$util$FileUtils = FileUtils.class$("bucket.util.FileUtils")) : class$bucket$util$FileUtils));
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((s = in.readLine()) != null) {
                String niceS = TextUtils.noNull((String)s).trim();
                if (!TextUtils.stringSet((String)niceS) || niceS.charAt(0) == '#') continue;
                result.add(s);
            }
            is.close();
        }
        catch (IOException e) {
            log.error((Object)("IOException reading stream: " + e), (Throwable)e);
        }
        return result;
    }

    public static String getResourceContent(String resource) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)resource, (Class)(class$bucket$util$FileUtils == null ? (class$bucket$util$FileUtils = FileUtils.class$("bucket.util.FileUtils")) : class$bucket$util$FileUtils));
        return FileUtils.getInputStreamTextContent(is);
    }

    public static String getResourceContent(HttpServletRequest req, String resource) {
        InputStream is = req.getSession().getServletContext().getResourceAsStream(resource);
        String result = FileUtils.getInputStreamTextContent(is);
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static String getInputStreamTextContent(InputStream is) {
        if (is == null) {
            return null;
        }
        String result = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
            FileUtils.pump(is, baos);
            result = new String(baos.toByteArray());
            is.close();
        }
        catch (IOException e) {
            log.error((Object)("IOException reading stream: " + e), (Throwable)e);
        }
        return result;
    }

    private static void pump(InputStream is, OutputStream os) throws IOException {
        int lengthRead;
        byte[] buffer = new byte[1024];
        while ((lengthRead = is.read(buffer)) >= 0) {
            os.write(buffer, 0, lengthRead);
        }
    }

    public static boolean deleteDir(File dir) {
        File candir;
        if (dir == null) {
            return false;
        }
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        if (!candir.equals(dir.getAbsoluteFile())) {
            return false;
        }
        File[] files = candir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                File file = files[i];
                boolean bl = deleted = !file.delete();
                if (!deleted || !file.isDirectory()) continue;
                FileUtils.deleteDir(file);
            }
        }
        return dir.delete();
    }

    public static boolean moveDir(File dirName, File destDir) {
        File destParent = new File(destDir.getParent());
        if (destDir.exists()) {
            destDir.delete();
        }
        destParent.mkdirs();
        return dirName.renameTo(destDir);
    }

    public static void recursiveDelete(File file) {
        File[] files = null;
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File next = files[i];
            FileUtils.recursiveDelete(next);
        }
        file.delete();
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        FileUtils.pump(in, out);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

