/*
 * Decompiled with CFR 0.152.
 */
package bucket.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final int[] CALENDAR_PERIODS = new int[]{1, 2, 5, 11, 12, 13, 14};

    public static Calendar getCalendarDay(int year, int month, int day) {
        return DateUtil.initCalendar(year, month, day, 0, 0, 0, 0);
    }

    public static Date getDateDay(int year, int month, int day) {
        return DateUtil.getCalendarDay(year, month, day).getTime();
    }

    public static Date getSqlDateDay(int year, int month, int day) {
        return new java.sql.Date(DateUtil.getCalendarDay(year, month, day).getTimeInMillis());
    }

    public static Calendar toEndOfPeriod(Calendar calendar, int period) {
        boolean zero = false;
        for (int i = 0; i < CALENDAR_PERIODS.length; ++i) {
            if (zero) {
                calendar.set(CALENDAR_PERIODS[i], calendar.getMaximum(CALENDAR_PERIODS[i]));
            }
            if (CALENDAR_PERIODS[i] != period) continue;
            zero = true;
        }
        if (!zero) {
            throw new IllegalArgumentException("unknown Calendar period: " + period);
        }
        return calendar;
    }

    public static Calendar toStartOfPeriod(Calendar calendar, int period) {
        boolean zero = false;
        for (int i = 0; i < CALENDAR_PERIODS.length; ++i) {
            if (zero) {
                if (CALENDAR_PERIODS[i] == 5) {
                    calendar.set(5, 1);
                } else {
                    calendar.set(CALENDAR_PERIODS[i], 0);
                }
            }
            if (CALENDAR_PERIODS[i] != period) continue;
            zero = true;
        }
        if (!zero) {
            throw new IllegalArgumentException("unknown Calendar period: " + period);
        }
        return calendar;
    }

    public static DateRange toDateRange(Calendar date, int period) {
        Calendar cal = (Calendar)date.clone();
        DateUtil.toStartOfPeriod(cal, period);
        Date startDate = new Date(cal.getTimeInMillis());
        cal.add(period, 1);
        Date endDate = new Date(cal.getTimeInMillis());
        return new DateRange(startDate, endDate);
    }

    public static Date tomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    private static Calendar initCalendar(int year, int month, int day, int hour, int minute, int second, int millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, minute, second);
        calendar.set(14, millis);
        return calendar;
    }

    public static class DateRange {
        public final Date startDate;
        public final Date endDate;

        public DateRange(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }
}

