/*
 * Decompiled with CFR 0.152.
 */
package bucket.util;

import bucket.container.ContainerManager;
import bucket.core.persistence.hibernate.HibernateConfig;
import bucket.util.LobSelector;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.UserType;
import net.sf.hibernate.util.EqualsHelper;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class BucketClobStringType
implements UserType {
    private boolean useSetClobAsString = false;
    static /* synthetic */ Class class$java$lang$String;

    private HibernateConfig getHibernateConfig() {
        return (HibernateConfig)ContainerManager.getComponent("hibernateConfig");
    }

    public boolean isUsingOracle() {
        return this.getHibernateConfig().isOracle();
    }

    public boolean isUsingHSQL() {
        return this.getHibernateConfig().isHSQL();
    }

    public boolean isUsingMySQL() {
        return this.getHibernateConfig().isMySql();
    }

    protected LobHandler getLobHandler() {
        return ((LobSelector)ContainerManager.getComponent("lobSelector")).getLobHandler();
    }

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return class$java$lang$String == null ? (class$java$lang$String = BucketClobStringType.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean equals(Object x, Object y) {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        int index = rs.findColumn(names[0]);
        if (this.isUsingOracle()) {
            String data = this.getLobHandler().getClobAsString(rs, index);
            data = data != null ? new String(data) : null;
        } else if (this.isUsingHSQL()) {
            return rs.getString(index);
        }
        return this.getLobHandler().getClobAsString(rs, index);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("ClobStringType requires active transaction synchronization");
        }
        LobCreator lobCreator = this.getLobHandler().getLobCreator();
        String data = (String)value;
        if (data == null) {
            data = "";
        }
        if (this.isUsingMySQL()) {
            lobCreator.setClobAsString(st, index, data);
        } else if (this.isUsingHSQL()) {
            st.setString(index, data);
        } else if (this.isUseSetClobAsString()) {
            lobCreator.setClobAsString(st, index, data);
        } else {
            lobCreator.setClobAsCharacterStream(st, index, (Reader)new StringReader(data), data.length());
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new LobCreatorSynchronization(lobCreator));
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    protected void setUseSetClobAsString(boolean b) {
        this.useSetClobAsString = b;
    }

    protected boolean isUseSetClobAsString() {
        return this.useSetClobAsString;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class LobCreatorSynchronization
    extends TransactionSynchronizationAdapter {
        private final LobCreator lobCreator;

        public LobCreatorSynchronization(LobCreator lobCreator) {
            this.lobCreator = lobCreator;
        }

        public void beforeCompletion() {
            this.lobCreator.close();
        }
    }
}

