/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.container.ContainerManager;
import bucket.core.InfrastructureException;
import bucket.propertyset.CachingPropertySet;
import bucket.user.providers.ChainedProfileProvider;
import com.atlassian.user.Caching;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Category;

public class CachingProfileProvider
extends ChainedProfileProvider
implements Caching {
    public static final String CACHE_KEY_PROFILE_PROVIDER_HANDLES = (class$bucket$user$providers$CachingProfileProvider == null ? (class$bucket$user$providers$CachingProfileProvider = CachingProfileProvider.class$("bucket.user.providers.CachingProfileProvider")) : class$bucket$user$providers$CachingProfileProvider).getName() + ".handles()";
    public static final String CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS = (class$bucket$user$providers$CachingProfileProvider == null ? (class$bucket$user$providers$CachingProfileProvider = CachingProfileProvider.class$("bucket.user.providers.CachingProfileProvider")) : class$bucket$user$providers$CachingProfileProvider).getName() + ".getPropertySet()";
    private static Category log = Category.getInstance((Class)(class$bucket$user$providers$CachingProfileProvider == null ? (class$bucket$user$providers$CachingProfileProvider = CachingProfileProvider.class$("bucket.user.providers.CachingProfileProvider")) : class$bucket$user$providers$CachingProfileProvider));
    private Cache handlesCache;
    private Cache propertySetsCache;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$bucket$user$providers$CachingProfileProvider;

    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup() && ContainerManager.getComponent("cacheManager") != null) {
            this.cacheManager = (CacheManager)ContainerManager.getComponent("cacheManager");
            this.initCaches();
        }
        return result;
    }

    public boolean handles(String name) {
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        try {
            Object element = this.handlesCache.get((Object)lowercasedName);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached handles() lookup for " + lowercasedName));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing handlesCache:" + e), (Throwable)e);
        }
        boolean result = super.handles(name);
        this.handlesCache.put((Object)lowercasedName, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching handles() result for " + lowercasedName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetsCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
                this.propertySetsCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.remove(name);
        }
    }

    public void flushCaches() {
        try {
            this.handlesCache.removeAll();
            this.propertySetsCache.removeAll();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        super.flushCaches();
    }

    public PropertySet getPropertySet(String name) {
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        Object element = this.propertySetsCache.get((Object)lowercasedName);
        if (element != null) {
            return (CachingPropertySet)element;
        }
        PropertySet ps = super.getPropertySet(name);
        HashMap<String, PropertySet> initParams = new HashMap<String, PropertySet>(2);
        initParams.put("PropertySet", ps);
        PropertySet cachedPs = PropertySetManager.getInstance((String)"cached", initParams);
        this.propertySetsCache.put((Object)lowercasedName, (Object)cachedPs);
        return cachedPs;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheManager != null) {
            this.handlesCache = this.cacheManager.getCache(CACHE_KEY_PROFILE_PROVIDER_HANDLES);
            if (this.handlesCache == null) {
                throw new InfrastructureException("Could not find a handles cache - check ehcache.xml for : " + CACHE_KEY_PROFILE_PROVIDER_HANDLES);
            }
            this.propertySetsCache = this.cacheManager.getCache(CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS);
            if (this.propertySetsCache == null) {
                throw new InfrastructureException("Could not find a property sets cache - check ehcache.xml for : " + CACHE_KEY_PROFILE_PROVIDER_PROPERTYSETS);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

