/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.container.ContainerManager;
import bucket.user.providers.ChainedCredentialsProvider;
import com.atlassian.user.Caching;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.opensymphony.util.TextUtils;
import java.util.Properties;
import org.apache.log4j.Category;

public class CachingCredentialsProvider
extends ChainedCredentialsProvider
implements Caching {
    private static Category log = Category.getInstance((Class)(class$bucket$user$providers$CachingCredentialsProvider == null ? (class$bucket$user$providers$CachingCredentialsProvider = CachingCredentialsProvider.class$("bucket.user.providers.CachingCredentialsProvider")) : class$bucket$user$providers$CachingCredentialsProvider));
    private Cache handlesCache;
    protected CacheManager cacheManager;
    static /* synthetic */ Class class$bucket$user$providers$CachingCredentialsProvider;

    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup() && ContainerManager.getComponent("cacheManager") != null) {
            this.cacheManager = (CacheManager)ContainerManager.getComponent("cacheManager");
            this.initCaches();
        }
        return result;
    }

    public boolean handles(String name) {
        String lowercasedName = TextUtils.noNull((String)name).toLowerCase();
        try {
            Object element = this.handlesCache.get((Object)lowercasedName);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached handles() lookup for " + lowercasedName));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing handlesCache:" + e), (Throwable)e);
        }
        boolean result = super.handles(name);
        this.handlesCache.put((Object)lowercasedName, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching handles() result for " + lowercasedName));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.remove(name);
        }
    }

    public void flushCaches() {
        try {
            this.handlesCache.removeAll();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        super.flushCaches();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheManager != null) {
            this.handlesCache = this.cacheManager.getCache(bucket.cache.CacheManager.CACHE_KEY_CREDENTIALS_PROVIDER);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

