/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.providers;

import bucket.container.ContainerManager;
import bucket.user.providers.ChainedAccessProvider;
import bucket.util.SerializablePairType;
import com.atlassian.user.Caching;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import java.util.Properties;
import org.apache.log4j.Category;

public class CachingAccessProvider
extends ChainedAccessProvider
implements Caching {
    private static Category log = Category.getInstance((Class)(class$bucket$user$providers$CachingAccessProvider == null ? (class$bucket$user$providers$CachingAccessProvider = CachingAccessProvider.class$("bucket.user.providers.CachingAccessProvider")) : class$bucket$user$providers$CachingAccessProvider));
    private Cache handlesCache;
    private Cache inGroupCache;
    protected CacheManager cacheManager;
    static /* synthetic */ Class class$bucket$user$providers$CachingAccessProvider;

    public boolean init(Properties properties) {
        boolean result = super.init(properties);
        if (ContainerManager.isContainerSetup() && ContainerManager.getComponent("cacheManager") != null) {
            this.cacheManager = (CacheManager)ContainerManager.getComponent("cacheManager");
            this.initCaches();
        }
        return result;
    }

    public boolean handles(String name) {
        try {
            Object element = this.handlesCache.get((Object)name);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached handles() lookup for " + name));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing handlesCache:" + e), (Throwable)e);
        }
        boolean result = super.handles(name);
        this.handlesCache.put((Object)name, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching handles() result for " + name));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.create(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) {
        Cache cache = this.handlesCache;
        synchronized (cache) {
            try {
                this.handlesCache.remove((Object)name);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.remove(name);
        }
    }

    public boolean inGroup(String username, String groupname) {
        SerializablePairType key = new SerializablePairType(username, groupname);
        try {
            Object element = this.inGroupCache.get((Object)key);
            if (element != null) {
                Boolean result = (Boolean)element;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found cached inGroup() lookup for " + key));
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error accessing inGroupCache:" + e), (Throwable)e);
        }
        boolean result = super.inGroup(username, groupname);
        this.inGroupCache.put((Object)key, (Object)result);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching inGroup() result for " + key));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToGroup(String username, String groupname) {
        Cache cache = this.inGroupCache;
        synchronized (cache) {
            try {
                this.inGroupCache.remove((Object)new SerializablePairType(username, groupname));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.addToGroup(username, groupname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromGroup(String username, String groupname) {
        Cache cache = this.inGroupCache;
        synchronized (cache) {
            try {
                this.inGroupCache.remove((Object)new SerializablePairType(username, groupname));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            return super.removeFromGroup(username, groupname);
        }
    }

    public void flushCaches() {
        this.flushCache(this.handlesCache);
        this.flushCache(this.inGroupCache);
        super.flushCaches();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.initCaches();
    }

    private void initCaches() {
        if (this.cacheManager != null) {
            this.handlesCache = this.cacheManager.getCache(bucket.cache.CacheManager.CACHE_KEY_ACCESS_PROVIDER_HANDLES);
            this.inGroupCache = this.cacheManager.getCache(bucket.cache.CacheManager.CACHE_KEY_ACCESS_PROVIDER_IN_GROUP);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

