/*
 * Decompiled with CFR 0.152.
 */
package bucket.user.persistence.dao.hibernate;

import bucket.cache.CacheManager;
import bucket.container.ContainerManager;
import com.atlassian.user.impl.cache.Cache;
import com.opensymphony.user.provider.hibernate.dao.HibernateQueries;
import com.opensymphony.user.provider.hibernate.dao.HibernateUserDAO;
import com.opensymphony.user.provider.hibernate.entity.HibernateGroup;
import com.opensymphony.user.provider.hibernate.entity.HibernateUser;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.type.Type;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public class BucketUserDAO
extends HibernateDaoSupport
implements HibernateUserDAO {
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Cache userCache;
    static /* synthetic */ Class class$com$opensymphony$user$provider$hibernate$impl$HibernateUserImpl;

    private Cache getCache() {
        if (this.userCache == null) {
            CacheManager cacheManager = (CacheManager)ContainerManager.getInstance().getContainerContext().getComponent("cacheManager");
            this.userCache = cacheManager.getCache(CacheManager.CACHE_KEY_USER_DAO_USERNAME);
        }
        return this.userCache;
    }

    public List findUsers() {
        List users = this.getHibernateTemplate().find(HibernateQueries.ALL_USERS);
        return users;
    }

    public HibernateUser findUserByUsername(final String username) {
        Object element = this.getCache().get((Object)username);
        if (element != null) {
            Long userId = (Long)element;
            return (HibernateUser)this.getHibernateTemplate().get(class$com$opensymphony$user$provider$hibernate$impl$HibernateUserImpl == null ? (class$com$opensymphony$user$provider$hibernate$impl$HibernateUserImpl = BucketUserDAO.class$("com.opensymphony.user.provider.hibernate.impl.HibernateUserImpl")) : class$com$opensymphony$user$provider$hibernate$impl$HibernateUserImpl, (Serializable)userId);
        }
        Iterator ret = (Iterator)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(HibernateQueries.USER_BY_USERNAME);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)BucketUserDAO.this.getSessionFactory());
                queryObject.setString(0, username);
                return queryObject.iterate();
            }
        });
        HibernateUser result = null;
        if (ret.hasNext()) {
            result = (HibernateUser)ret.next();
        }
        if (result == null) {
            this.getCache().put((Object)username, null);
        } else {
            this.getCache().put((Object)username, (Object)new Long(result.getId()));
        }
        return result;
    }

    public int deleteUserByUsername(String username) {
        List userByUserNameList = this.getHibernateTemplate().find("select distinct hibuser from com.opensymphony.user.provider.hibernate.entity.HibernateUser as hibuser where hibuser.name = ?", (Object)username, (Type)Hibernate.STRING);
        for (int i = 0; i < userByUserNameList.size(); ++i) {
            HibernateUser hibernateUser = (HibernateUser)userByUserNameList.get(i);
            Iterator iter = hibernateUser.getGroupList().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                hibernateUser.removeGroup((HibernateGroup)o);
            }
        }
        try {
            this.getCache().remove((Object)username);
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        if (userByUserNameList.size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)userByUserNameList);
            return userByUserNameList.size();
        }
        return 0;
    }

    public boolean updateUser(HibernateUser user) {
        try {
            this.getCache().remove((Object)user.getName());
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        this.getHibernateTemplate().saveOrUpdate((Object)user);
        return true;
    }

    public HibernateUser findUserByUsernameAndGroupname(final String userName, final String groupName) {
        List results = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(HibernateQueries.USER_BY_USERNAME_AND_GROUPNAME);
                queryObject.setCacheable(true);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)BucketUserDAO.this.getSessionFactory());
                queryObject.setString(0, userName);
                queryObject.setString(1, groupName);
                return queryObject.list();
            }
        });
        if (results.size() == 0) {
            return null;
        }
        HibernateUser foundHibernateUser = (HibernateUser)results.get(0);
        return foundHibernateUser;
    }

    public boolean saveUser(HibernateUser user) {
        Serializable id;
        if (user != null) {
            try {
                this.getCache().remove((Object)user.getName());
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
        return (id = this.getHibernateTemplate().save((Object)user)) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

