/*
 * Decompiled with CFR 0.152.
 */
package bucket.upgrade;

import bucket.cache.CacheManager;
import bucket.config.ApplicationConfiguration;
import bucket.container.ContainerManager;
import bucket.core.persistence.hibernate.schema.SchemaHelper;
import bucket.upgrade.BuildNumComparator;
import bucket.upgrade.UpgradeException;
import bucket.upgrade.UpgradeManager;
import bucket.upgrade.UpgradeTask;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Category;

public abstract class AbstractUpgradeManager
implements UpgradeManager {
    private static Category log = Category.getInstance((Class)(class$bucket$upgrade$UpgradeManager == null ? (class$bucket$upgrade$UpgradeManager = AbstractUpgradeManager.class$("bucket.upgrade.UpgradeManager")) : class$bucket$upgrade$UpgradeManager));
    public static final String UPGRADE_TYPE_STANDARD = "standardUpgrade";
    public static final String UPGRADE_TYPE_ENTERPRISE = "enterpriseUpgrade";
    public static final String UPGRADE_TYPE_STANDARD_TO_ENTERPRISE = "standardToEnterpriseUpgrade";
    private ApplicationConfiguration applicationConfig;
    private List upgradeTasks = new ArrayList();
    private List preSchemaUpgradeTasks = new ArrayList();
    private List schemaUpgradeTasks = new ArrayList();
    private List errors = new ArrayList();
    protected Comparator buildNumberComp = new BuildNumComparator();
    protected ServletContext servletContext;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$bucket$upgrade$UpgradeManager;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationConfig(ApplicationConfiguration applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void upgrade() throws UpgradeException {
        try {
            if (this.isUpgradeAllowed()) {
                this.upgradeStarted();
                if ("true".equals(System.getProperty("atlassian.forceSchemaUpdate")) || this.needUpgrade()) {
                    this.upgradeSchema();
                }
                if (this.needUpgrade()) {
                    this.doUpgrade();
                }
                this.upgradeFinished();
            } else {
                this.addJohnsonEvent("Cannot proceed with upgrade. Your current license does not entitle you to upgrade to this version of Confluence. Please check that the support period of your license has not expired or that you have the correct partner license. If you wish to renew your license, please contact sales@atlassian.com. If you have a new license, please enter it on this <a href='admin/license.action?restartReminder=true'>page</a> and <b>restart</b>.");
            }
        }
        catch (UpgradeException e) {
            this.addJohnsonEvent();
            throw e;
        }
        catch (Throwable e) {
            log.error((Object)("Exception thrown during upgrade: " + e.getMessage()), e);
            this.addJohnsonEvent();
            throw new UpgradeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Throwable {
        try {
            String currentBuildNumber = this.getConfiguredBuildNumber();
            List upgradeTasks = this.getUpgradeTasks();
            Iterator iterator = upgradeTasks.iterator();
            while (iterator.hasNext()) {
                Object var8_7;
                UpgradeTask upgradeTask = (UpgradeTask)iterator.next();
                boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(currentBuildNumber, upgradeTask.getBuildNumber()) < 0;
                if (!patchBuildGreaterThanCurrent) continue;
                try {
                    try {
                        upgradeTask.doUpgrade();
                        this.upgradeTaskSucceeded(upgradeTask);
                    }
                    catch (Exception e) {
                        this.upgradeTaskFailed(upgradeTask, e);
                        throw e;
                    }
                    var8_7 = null;
                    if (upgradeTask.getErrors() != null) {
                        this.errors.addAll(upgradeTask.getErrors());
                    }
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (upgradeTask.getErrors() != null) {
                        this.errors.addAll(upgradeTask.getErrors());
                    }
                    this.cacheManager.flushCaches();
                    throw throwable;
                }
                this.cacheManager.flushCaches();
            }
            return;
        }
        catch (Throwable e) {
            log.error((Object)("Upgrade failed: " + e.getMessage()), e);
            throw new UpgradeException(e);
        }
    }

    protected void upgradeSchema() {
        try {
            ApplicationConfiguration config;
            this.runUpgradeTasksAndSwallowErrors(this.preSchemaUpgradeTasks);
            if (ContainerManager.isContainerSetup() && (config = (ApplicationConfiguration)ContainerManager.getComponent("applicationConfig")).isSetupComplete()) {
                SchemaHelper schemaHelper = (SchemaHelper)ContainerManager.getComponent("schemaHelper");
                schemaHelper.updateSchemaIfNeeded();
            }
            this.runUpgradeTasksAndSwallowErrors(this.getSchemaUpgradeTasks());
        }
        catch (Throwable t) {
            log.fatal((Object)"Could not update schema.", t);
        }
    }

    private void runUpgradeTasksAndSwallowErrors(List upgradeTasks) {
        String currentBuildNumber = this.getConfiguredBuildNumber();
        Iterator iterator = upgradeTasks.iterator();
        while (iterator.hasNext()) {
            UpgradeTask upgradeTask = (UpgradeTask)iterator.next();
            boolean patchBuildGreaterThanCurrent = this.buildNumberComp.compare(currentBuildNumber, upgradeTask.getBuildNumber()) < 0;
            if (!patchBuildGreaterThanCurrent) continue;
            try {
                upgradeTask.doUpgrade();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    protected void upgradeTaskSucceeded(UpgradeTask upgradeTask) {
        this.setConfiguredBuildNumber(upgradeTask.getBuildNumber());
    }

    protected void upgradeTaskFailed(UpgradeTask upgradeTask, Throwable e) {
        if (upgradeTask.getErrors() == null || upgradeTask.getErrors().size() == 0) {
            this.errors.add(e.getMessage());
        }
    }

    private void addJohnsonEvent() {
        this.addJohnsonEvent("Upgrade failed. Please consult the system logs for details. You will need to fix these problems and restart.");
    }

    private void addJohnsonEvent(String message) {
        JohnsonEventContainer johnsonContainer;
        if (this.servletContext != null && (johnsonContainer = JohnsonEventContainer.get((ServletContext)this.servletContext)) != null) {
            johnsonContainer.addEvent(new Event(EventType.get((String)"upgrade"), message, "fatal"));
        }
    }

    protected String getUpgradeManagerType() {
        return UPGRADE_TYPE_STANDARD;
    }

    protected void upgradeStarted() throws Exception {
    }

    public void setPreSchemaUpgradeTasks(List preSchemaUpgradeTasks) {
        this.preSchemaUpgradeTasks = preSchemaUpgradeTasks;
    }

    public void setUpgradeTasks(List upgradeTasks) {
        this.upgradeTasks = upgradeTasks;
    }

    public List getUpgradeTasks() {
        return this.upgradeTasks;
    }

    public void setSchemaUpgradeTasks(List upgradeTasks) {
        this.schemaUpgradeTasks = upgradeTasks;
    }

    public List getSchemaUpgradeTasks() {
        return this.schemaUpgradeTasks;
    }

    public List getErrors() {
        return this.errors;
    }

    public boolean isUpgradeAllowed() {
        return true;
    }

    protected String getConfiguredBuildNumber() {
        return this.applicationConfig.getBuildNumber();
    }

    protected void setConfiguredBuildNumber(String buildNumber) {
        this.applicationConfig.setBuildNumber(buildNumber);
    }

    public boolean needUpgrade() {
        boolean afterSetup = this.applicationConfig.isSetupComplete();
        try {
            int realBuildNumber = Integer.parseInt(this.getRealBuildNumber());
            int configuredBuildNumber = Integer.parseInt(this.getConfiguredBuildNumber());
            boolean differentBuildNumbers = realBuildNumber != configuredBuildNumber;
            return afterSetup && differentBuildNumbers;
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Build numbers are not parseable. Upgrade skipped");
            return false;
        }
    }

    protected void upgradeFinished() throws Exception {
        this.applicationConfig.setBuildNumber(this.getRealBuildNumber());
        this.applicationConfig.save();
    }

    protected abstract String getRealBuildNumber();

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

