/*
 * Decompiled with CFR 0.152.
 */
package bucket.test.container;

import bucket.core.persistence.hibernate.MappingResources;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.HibernateTemplate;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;

public class LocalSessionFactoryBeanForTests
extends LocalSessionFactoryBean {
    private MappingResources mappingResources;

    public Configuration newConfiguration() throws HibernateException {
        Configuration config = new Configuration();
        this.setConfigLocation(null);
        super.setMappingResources(this.mappingResources.getMappingsAsArray());
        return config;
    }

    protected void executeSchemaUpdate(final Configuration config) throws HibernateException {
        final Dialect dialect = Dialect.getDialect((Properties)config.getProperties());
        HibernateTemplate template = new HibernateTemplate((SessionFactory)this.getObject());
        template.execute(new HibernateCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Connection conn = session.connection();
                DatabaseMetadata metadata = new DatabaseMetadata(conn, dialect);
                String[] sql = config.generateSchemaUpdateScript(dialect, metadata);
                Statement stmt = conn.createStatement();
                try {
                    for (int i = 0; i < sql.length; ++i) {
                        System.out.println("Executing [" + sql[i] + "]");
                        stmt.executeUpdate(sql[i]);
                    }
                }
                finally {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public MappingResources getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(MappingResources mappingResources) {
        this.mappingResources = mappingResources;
    }
}

