/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.persistence.dao.hibernate;

import bucket.core.persistence.hibernate.HibernateObjectDao;
import bucket.search.persistence.IndexQueueEntry;
import bucket.search.persistence.dao.IndexQueueEntryDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.apache.log4j.Category;
import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateIndexQueueEntryDao
extends HibernateObjectDao
implements IndexQueueEntryDao {
    public static final Category LOG = Category.getInstance((Class)(class$bucket$search$persistence$dao$hibernate$HibernateIndexQueueEntryDao == null ? (class$bucket$search$persistence$dao$hibernate$HibernateIndexQueueEntryDao = HibernateIndexQueueEntryDao.class$("bucket.search.persistence.dao.hibernate.HibernateIndexQueueEntryDao")) : class$bucket$search$persistence$dao$hibernate$HibernateIndexQueueEntryDao));
    static /* synthetic */ Class class$bucket$search$persistence$dao$hibernate$HibernateIndexQueueEntryDao;
    static /* synthetic */ Class class$bucket$search$persistence$IndexQueueEntry;

    public Class getPersistentClass() {
        return class$bucket$search$persistence$IndexQueueEntry == null ? (class$bucket$search$persistence$IndexQueueEntry = HibernateIndexQueueEntryDao.class$("bucket.search.persistence.IndexQueueEntry")) : class$bucket$search$persistence$IndexQueueEntry;
    }

    public void saveOrUpdate(IndexQueueEntry entry) {
        if (entry.getCreationDate() == null) {
            entry.setCreationDate(new Date());
        }
        this.getHibernateTemplate().saveOrUpdate((Object)entry);
    }

    public List getNewEntries(Date since) {
        return this.getHibernateTemplate().find("from IndexQueueEntry where creationDate > ? order by creationDate", (Object)since);
    }

    public int getNewEntryCount(final Date since) {
        Integer count = (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("select count(*) from IndexQueueEntry where creationDate >= :creationDate");
                queryObject.setTimestamp("creationDate", since);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateIndexQueueEntryDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
        return count;
    }

    public void deleteAllBefore(final Date since) {
        this.executeSqlDelete(new SQLDeleteAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection con) throws SQLException {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("delete from INDEXQUEUEENTRIES where CREATIONDATE < ?");
                    ps.setTimestamp(1, new Timestamp(since.getTime()));
                    int rowsDeleted = ps.executeUpdate();
                    if (rowsDeleted > 0 && LOG.isDebugEnabled()) {
                        LOG.debug((Object)(rowsDeleted + " entried deleted from the INDEX QUEUE ENTRIES table."));
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        });
    }

    public void deleteAll() {
        this.executeSqlDelete(new SQLDeleteAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection con) throws SQLException {
                PreparedStatement ps = null;
                try {
                    ps = con.prepareStatement("delete from INDEXQUEUEENTRIES");
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        });
    }

    private void executeSqlDelete(final SQLDeleteAction action) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Connection connection = session.connection();
                try {
                    session.flush();
                    action.execute(connection);
                    HibernateIndexQueueEntryDao.this.getSessionFactory().evict(class$bucket$search$persistence$IndexQueueEntry == null ? (class$bucket$search$persistence$IndexQueueEntry = HibernateIndexQueueEntryDao.class$("bucket.search.persistence.IndexQueueEntry")) : class$bucket$search$persistence$IndexQueueEntry);
                }
                catch (SQLException e) {
                    throw new HibernateException((Throwable)e);
                }
                return null;
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static interface SQLDeleteAction {
        public void execute(Connection var1) throws SQLException;
    }
}

