/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.Searchable;
import bucket.search.lucene.Extractor;
import bucket.search.lucene.LuceneException;
import bucket.search.lucene.LuceneUtils;
import bucket.search.lucene.extractor.XmlClassConfigurations;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import net.sf.hibernate.Hibernate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class XmlConfiguredExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        XmlClassConfigurations.ClassConfiguration classConfig = XmlClassConfigurations.getClassConfiguration(Hibernate.getClass((Object)searchable));
        if (classConfig != null) {
            Iterator iter = classConfig.getFieldConfigurations().iterator();
            while (iter.hasNext()) {
                XmlClassConfigurations.FieldConfiguration fieldConfiguration = (XmlClassConfigurations.FieldConfiguration)iter.next();
                String[] attributeNames = fieldConfiguration.getAttributeName().split(",");
                for (int i = 0; i < attributeNames.length; ++i) {
                    Object o = this.getContentOfAttribute(searchable, attributeNames[i]);
                    if (o.getClass().isArray()) {
                        this.indexArrayField(document, fieldConfiguration, o);
                        continue;
                    }
                    if (o instanceof Collection) {
                        this.indexCollectionField(document, fieldConfiguration, (Collection)o);
                        continue;
                    }
                    if (o instanceof Date && fieldConfiguration.getType().equals("Keyword")) {
                        this.indexDateField(document, fieldConfiguration, (Date)o);
                        continue;
                    }
                    if ("contentBody".equals(fieldConfiguration.getFieldName())) {
                        defaultSearchableText.append(String.valueOf(o));
                        continue;
                    }
                    this.indexStringField(document, fieldConfiguration, String.valueOf(o));
                }
            }
        }
    }

    private void indexDateField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Date date) {
        Field field = Field.Keyword((String)fieldConfiguration.getFieldName(), (String)LuceneUtils.dateToString(date));
        doc.add(field);
    }

    private void indexArrayField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Object arr) {
        int length = Array.getLength(arr);
        for (int i = 0; i < length; ++i) {
            Object o = Array.get(arr, i);
            this.indexStringField(doc, fieldConfiguration, String.valueOf(o));
        }
    }

    private void indexCollectionField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.indexStringField(doc, fieldConfiguration, String.valueOf(o));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void indexStringField(Document doc, XmlClassConfigurations.FieldConfiguration fieldConfiguration, String strContent) {
        void var4_4;
        Field field;
        if (fieldConfiguration.getType().equals("Text")) {
            field = Field.Text((String)fieldConfiguration.getFieldName(), (String)strContent);
        } else if (fieldConfiguration.getType().equals("Keyword")) {
            field = Field.Keyword((String)fieldConfiguration.getFieldName(), (String)strContent);
        } else if (fieldConfiguration.getType().equals("UnIndexed")) {
            field = Field.UnIndexed((String)fieldConfiguration.getFieldName(), (String)strContent);
        } else if (fieldConfiguration.getType().equals("UnStored")) {
            field = Field.UnStored((String)fieldConfiguration.getFieldName(), (String)strContent);
        } else {
            throw new LuceneException("Unknown type for a field, fieldName=" + fieldConfiguration.getFieldName());
        }
        doc.add((Field)var4_4);
    }

    private Object getContentOfAttribute(Object obj, String attributeName) {
        try {
            String[] attributes = attributeName.split("\\.");
            Object o = null;
            for (int i = 0; i < attributes.length; ++i) {
                o = PropertyUtils.getProperty((Object)obj, (String)attributeName);
            }
            return o == null ? "" : o;
        }
        catch (IllegalAccessException iae) {
            throw new LuceneException("Couldn't get string content of attribute, as property accessor method for " + attributeName + " cannot be accessed");
        }
        catch (NoSuchMethodException e) {
            throw new LuceneException("Couldn't get string content of attribute, as no such property accessor method for " + attributeName + " exists");
        }
        catch (InvocationTargetException e) {
            throw new LuceneException("Calling property accessor method for attribute " + attributeName + " threw an exception", e);
        }
    }
}

