/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.lucene.LuceneException;
import com.opensymphony.util.TextUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

final class XmlClassConfigurations {
    public static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$extractor$XmlClassConfigurations == null ? (class$bucket$search$lucene$extractor$XmlClassConfigurations = XmlClassConfigurations.class$("bucket.search.lucene.extractor.XmlClassConfigurations")) : class$bucket$search$lucene$extractor$XmlClassConfigurations));
    private static Map classConfigurations = new HashMap();
    private static List unconfiguredClasses = new ArrayList();
    static /* synthetic */ Class class$bucket$search$lucene$extractor$XmlClassConfigurations;

    XmlClassConfigurations() {
    }

    private static void addClassConfiguration(Class clazz, ClassConfiguration classConfiguration) {
        classConfigurations.put(clazz.getName(), classConfiguration);
    }

    private static ClassConfiguration loadClassConfiguration(Class clazz) {
        InputStream configXml = XmlClassConfigurations.loadConfigFile(clazz);
        if (configXml == null) {
            unconfiguredClasses.add(clazz);
            log.debug((Object)("Lucene configuration file not found for class: " + clazz.toString()));
            return null;
        }
        ClassConfiguration newClassConfig = new ClassConfiguration();
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(configXml);
            XPath mapXPath = DocumentHelper.createXPath((String)"/configuration/field");
            List mappings = mapXPath.selectNodes((Object)doc);
            Iterator it = mappings.iterator();
            while (it.hasNext()) {
                Element mappingNode = (Element)it.next();
                FieldConfiguration mapping = new FieldConfiguration();
                mapping.setType(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "type"));
                mapping.setFieldName(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "fieldName"));
                mapping.setAttributeName(XmlClassConfigurations.safeStringAttributeGet(mappingNode, "attributeName"));
                newClassConfig.addFieldConfiguration(mapping);
            }
            XmlClassConfigurations.addClassConfiguration(clazz, newClassConfig);
            return newClassConfig;
        }
        catch (Exception e) {
            throw new LuceneException("Couldn't load lucene config file successfully, file=" + clazz, e);
        }
    }

    private static String safeStringAttributeGet(Element mappingNode, String attributeName) {
        Attribute attribute = mappingNode.attribute(attributeName);
        if (attribute != null && TextUtils.stringSet((String)attribute.getValue())) {
            return attribute.getValue();
        }
        return null;
    }

    private static InputStream loadConfigFile(Class clazz) {
        String configFileName = clazz.getName().replace('.', '/') + ".lucene.xml";
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(configFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassConfiguration getClassConfiguration(Class clazz) {
        ClassConfiguration classConfig;
        Map map = classConfigurations;
        synchronized (map) {
            classConfig = (ClassConfiguration)classConfigurations.get(clazz.getName());
            if (classConfig == null && !unconfiguredClasses.contains(clazz)) {
                classConfig = XmlClassConfigurations.loadClassConfiguration(clazz);
            }
        }
        return classConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class FieldConfiguration {
        public static final String TYPE_TEXT = "Text";
        public static final String TYPE_KEYWORD = "Keyword";
        public static final String TYPE_UNINDEXED = "UnIndexed";
        public static final String TYPE_UNSTORED = "UnStored";
        private String type;
        private String fieldName;
        private String attributeName;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }
    }

    public static final class ClassConfiguration {
        private List fieldConfigurations = new ArrayList();

        public void addFieldConfiguration(FieldConfiguration fieldConfiguration) {
            this.fieldConfigurations.add(fieldConfiguration);
        }

        public List getFieldConfigurations() {
            return this.fieldConfigurations;
        }
    }
}

