/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.lucene.SearchableAttachment;
import bucket.search.lucene.extractor.BaseAttachmentContentExtractor;
import bucket.search.lucene.extractor.ExtractorException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.log4j.Category;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class PdfContentExtractor
extends BaseAttachmentContentExtractor {
    public static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$extractor$PdfContentExtractor == null ? (class$bucket$search$lucene$extractor$PdfContentExtractor = PdfContentExtractor.class$("bucket.search.lucene.extractor.PdfContentExtractor")) : class$bucket$search$lucene$extractor$PdfContentExtractor));
    private static final String[] EXTENSIONS = new String[]{"pdf"};
    private static final String[] CONTENT_TYPES = new String[]{"application/pdf"};
    static /* synthetic */ Class class$bucket$search$lucene$extractor$PdfContentExtractor;

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        String string;
        PDDocument pdfDocument = null;
        try {
            try {
                pdfDocument = PDDocument.load((InputStream)is);
                if (pdfDocument.isEncrypted()) {
                    pdfDocument.decrypt("");
                }
                StringWriter writer = new StringWriter();
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.writeText(pdfDocument, (Writer)writer);
                writer.close();
                string = writer.getBuffer().toString();
                Object var8_10 = null;
                if (pdfDocument == null) return string;
            }
            catch (CryptographyException e) {
                throw new ExtractorException("Could not decrypt PDF document", e);
            }
            catch (InvalidPasswordException e) {
                throw new ExtractorException("Password required for encrypted PDF document", e);
            }
            catch (Exception e) {
                throw new ExtractorException("Error getting content of PDF document", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (pdfDocument == null) throw throwable;
            try {
                pdfDocument.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return string;
        }
        pdfDocument.close();
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

