/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.lucene.SearchableAttachment;
import bucket.search.lucene.extractor.BaseAttachmentContentExtractor;
import bucket.search.lucene.extractor.ExtractorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;

public class MsPowerpointContentExtractor
extends BaseAttachmentContentExtractor {
    static final byte[] MASTER_TITLE_STYLE = "Click to edit Master title style".getBytes();
    static final byte[] MASTER_TEXT_STYLE = "Click to edit Master text styles".getBytes();
    public static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$extractor$MsPowerpointContentExtractor == null ? (class$bucket$search$lucene$extractor$MsPowerpointContentExtractor = MsPowerpointContentExtractor.class$("bucket.search.lucene.extractor.MsPowerpointContentExtractor")) : class$bucket$search$lucene$extractor$MsPowerpointContentExtractor));
    private static final String[] CONTENT_TYPES = new String[]{"application/powerpoint", "application/mspowerpoint", "application/x-mspowerpoint", "application/vnd.ms-powerpoint"};
    private static final String[] EXTENSIONS = new String[]{"ppt"};
    static /* synthetic */ Class class$bucket$search$lucene$extractor$MsPowerpointContentExtractor;

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        StringBuffer content = new StringBuffer();
        POIFSReader r = new POIFSReader();
        r.registerListener((POIFSReaderListener)new PowerPointListener(content));
        try {
            r.read(is);
        }
        catch (IOException e) {
            throw new ExtractorException("Error reading content of Powerpoint document", e);
        }
        return content.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PowerPointListener
    implements POIFSReaderListener {
        private final StringBuffer buff;
        private static final byte SPACE = " ".getBytes()[0];

        public PowerPointListener(StringBuffer buff) {
            this.buff = buff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            block9: {
                try {
                    DocumentInputStream dis = null;
                    if (!event.getName().equals("PowerPoint Document")) break block9;
                    dis = event.getStream();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try {
                        byte[] btoWrite = new byte[dis.available()];
                        dis.read(btoWrite, 0, dis.available());
                        boolean masterTitleFound = false;
                        boolean masterStylesFound = false;
                        for (int i = 0; i < btoWrite.length - 20; ++i) {
                            long type = LittleEndian.getUShort((byte[])btoWrite, (int)(i + 2));
                            long size = LittleEndian.getUInt((byte[])btoWrite, (int)(i + 4));
                            if (type != 4008L) continue;
                            if (size > 1000L) {
                                log.error((Object)("Looks like an invalid size? " + size));
                                continue;
                            }
                            byte[] b = new byte[(int)size];
                            System.arraycopy(btoWrite, i + 4 + 4, b, 0, (int)size);
                            if (!masterTitleFound && this.arrayStartsWith(b, MASTER_TITLE_STYLE)) {
                                masterTitleFound = true;
                                continue;
                            }
                            if (!masterStylesFound && this.arrayStartsWith(b, MASTER_TEXT_STYLE)) {
                                masterStylesFound = true;
                                continue;
                            }
                            bos.write(b);
                            bos.write(SPACE);
                        }
                        this.buff.append(new String(bos.toByteArray()));
                    }
                    finally {
                        dis.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error extracting PowerPoint text: " + e), (Throwable)e);
                }
            }
        }

        private boolean arrayStartsWith(byte[] arr, byte[] startsWith) {
            for (int i = 0; i < startsWith.length; ++i) {
                if (arr[i] == startsWith[i]) continue;
                return false;
            }
            return true;
        }
    }
}

