/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.lucene.SearchableAttachment;
import bucket.search.lucene.extractor.BaseAttachmentContentExtractor;
import bucket.search.lucene.extractor.ExtractorException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MsExcelContentExtractor
extends BaseAttachmentContentExtractor {
    public static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$extractor$MsExcelContentExtractor == null ? (class$bucket$search$lucene$extractor$MsExcelContentExtractor = MsExcelContentExtractor.class$("bucket.search.lucene.extractor.MsExcelContentExtractor")) : class$bucket$search$lucene$extractor$MsExcelContentExtractor));
    private static final String[] CONTENT_TYPES = new String[]{"application/excel", "application/x-excel", "application/x-msexcel", "application/vnd.ms-excel"};
    private static final String[] EXTENSIONS = new String[]{"xls"};
    static /* synthetic */ Class class$bucket$search$lucene$extractor$MsExcelContentExtractor;

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        StringBuffer content = new StringBuffer();
        DocumentInputStream din = null;
        try {
            try {
                POIFSFileSystem poifs = new POIFSFileSystem(is);
                din = poifs.createDocumentInputStream("Workbook");
                HSSFRequest req = new HSSFRequest();
                req.addListenerForAllRecords((HSSFListener)new EventCatcher(content));
                HSSFEventFactory factory = new HSSFEventFactory();
                factory.processEvents(req, (InputStream)din);
            }
            catch (IOException e) {
                throw new ExtractorException("Error reading content of Excel document", e);
            }
            Object var9_9 = null;
            if (din == null) return content.toString();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (din == null) throw throwable;
            try {
                din.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        din.close();
        return content.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EventCatcher
    implements HSSFListener {
        private final StringBuffer buff;
        private SSTRecord sstrec;
        private static final char SPACE = ' ';

        public EventCatcher(StringBuffer buff) {
            this.buff = buff;
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    this.buff.append(numrec.getValue() + 32.0);
                    break;
                }
                case 252: {
                    this.sstrec = (SSTRecord)record;
                    for (int k = 0; k < this.sstrec.getNumUniqueStrings(); ++k) {
                        this.buff.append(this.sstrec.getString(k)).append(' ');
                    }
                    break;
                }
                case 253: {
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    this.buff.append(this.sstrec.getString(lrec.getSSTIndex())).append(' ');
                }
            }
        }
    }
}

