/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.core.EntityObject;
import bucket.search.Searchable;
import bucket.search.lucene.Extractor;
import bucket.search.lucene.LuceneUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class EntityObjectDateExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof EntityObject) {
            EntityObject eo = (EntityObject)((Object)searchable);
            Field dateModifiedField = Field.Keyword((String)"modified", (String)LuceneUtils.dateToString(eo.getLastModificationDate()));
            document.add(dateModifiedField);
            document.add(Field.Keyword((String)"created", (String)LuceneUtils.dateToString(eo.getCreationDate())));
        }
    }
}

