/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.Searchable;
import bucket.search.lucene.Extractor;
import bucket.search.lucene.SearchableAttachment;
import bucket.search.lucene.extractor.ExtractorException;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;

public abstract class BaseAttachmentContentExtractor
implements Extractor {
    public static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$extractor$BaseAttachmentContentExtractor == null ? (class$bucket$search$lucene$extractor$BaseAttachmentContentExtractor = BaseAttachmentContentExtractor.class$("bucket.search.lucene.extractor.BaseAttachmentContentExtractor")) : class$bucket$search$lucene$extractor$BaseAttachmentContentExtractor));
    static /* synthetic */ Class class$bucket$search$lucene$extractor$BaseAttachmentContentExtractor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        String contentType;
        if (!(searchable instanceof SearchableAttachment)) {
            return;
        }
        if (document.getField("contentBody") != null) {
            return;
        }
        if (defaultSearchableText.length() != 0) {
            return;
        }
        SearchableAttachment attachment = (SearchableAttachment)searchable;
        String fileName = TextUtils.noNull((String)attachment.getFileName()).toLowerCase();
        if (!this.shouldExtractFrom(fileName, contentType = attachment.getContentType())) {
            return;
        }
        InputStream is = null;
        is = attachment.getContentsAsStream();
        defaultSearchableText.append(this.extractText(is, attachment));
        Object var10_8 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                log.error((Object)("Error reading attachment (" + attachment.getFileName() + "): " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                Object var10_9 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (ExtractorException e) {
                log.error((Object)("Error indexing attachment (" + attachment.getFileName() + "): " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                Object var10_10 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
            catch (RuntimeException e) {
                log.error((Object)("Error indexing attachment (" + attachment.getFileName() + "): " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                Object var10_11 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected boolean shouldExtractFrom(String fileName, String contentType) {
        int i;
        for (i = 0; i < this.getMatchingFileExtensions().length; ++i) {
            if (!fileName.endsWith(this.getMatchingFileExtensions()[i])) continue;
            return true;
        }
        for (i = 0; i < this.getMatchingContentTypes().length; ++i) {
            String validType = this.getMatchingContentTypes()[i];
            if (!validType.equalsIgnoreCase(contentType)) continue;
            return true;
        }
        return false;
    }

    protected String[] getMatchingContentTypes() {
        return new String[0];
    }

    protected String[] getMatchingFileExtensions() {
        return new String[0];
    }

    abstract String extractText(InputStream var1, SearchableAttachment var2) throws ExtractorException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

