/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene.extractor;

import bucket.search.Searchable;
import bucket.search.lucene.Extractor;
import bucket.search.lucene.SearchableAttachment;
import com.opensymphony.util.TextUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class AttachmentMetadataExtractor
implements Extractor {
    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        if (searchable instanceof SearchableAttachment) {
            SearchableAttachment attachment = (SearchableAttachment)searchable;
            if (TextUtils.stringSet((String)attachment.getFileName())) {
                Field fileNameField = Field.Text((String)"filename", (String)attachment.getFileName());
                document.add(fileNameField);
                document.add(Field.UnIndexed((String)"title", (String)attachment.getFileName()));
            }
            if (TextUtils.stringSet((String)attachment.getComment())) {
                Field commentField = Field.Text((String)"comment", (String)attachment.getComment());
                document.add(commentField);
                defaultSearchableText.append(attachment.getComment());
            }
            if (TextUtils.stringSet((String)attachment.getNiceType())) {
                document.add(Field.UnIndexed((String)"niceType", (String)attachment.getNiceType()));
            }
            if (TextUtils.stringSet((String)attachment.getDownloadPath())) {
                document.add(Field.UnIndexed((String)"downloadPath", (String)attachment.getDownloadPath()));
            }
            if (TextUtils.stringSet((String)attachment.getNiceFileSize())) {
                document.add(Field.UnIndexed((String)"niceFileSize", (String)attachment.getNiceFileSize()));
            }
        }
    }
}

