/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuceneUtils {
    protected static Category log = Category.getInstance((Class)(class$bucket$search$lucene$LuceneUtils == null ? (class$bucket$search$lucene$LuceneUtils = LuceneUtils.class$("bucket.search.lucene.LuceneUtils")) : class$bucket$search$lucene$LuceneUtils));
    static /* synthetic */ Class class$bucket$search$lucene$LuceneUtils;

    public static String dateToString(Date date) {
        return DateField.dateToString((Date)date);
    }

    public static Date stringToDate(String s) {
        if (s != null && s.trim().length() > 0) {
            return DateField.stringToDate((String)s);
        }
        return new Date();
    }

    public static Query buildSingleFieldSingleValueTermQuery(String field, String query) {
        return LuceneUtils.buildSingleFieldMultiValueTermQuery(field, Collections.singletonList(query), true);
    }

    public static Query buildSingleFieldMultiValueTermQuery(String field, Collection values, boolean andQuery) {
        BooleanQuery query = new BooleanQuery();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            query.add((Query)new TermQuery(new Term(field, value)), andQuery, false);
        }
        return query;
    }

    public static Query buildSingleFieldMultiValuePrefixQuery(String field, Collection values, boolean andQuery) {
        BooleanQuery query = new BooleanQuery();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = (String)iterator.next();
            query.add((Query)new PrefixQuery(new Term(field, value)), andQuery, false);
        }
        return query;
    }

    public static Map buildMapFromDocument(Document doc) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration e = doc.fields();
        block0: while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            String fieldname = f.name();
            if (fieldname.indexOf(46) > -1) {
                String[] split = fieldname.split("\\.");
                Map last = result;
                for (int i = 0; i < split.length; ++i) {
                    String key = split[i];
                    if (i == split.length - 1) {
                        last.put(key, f.stringValue());
                        continue;
                    }
                    Object temp = last.get(key);
                    if (temp != null && !(temp instanceof Map)) continue block0;
                    if (temp == null) {
                        temp = new HashMap(5);
                        last.put(key, temp);
                    }
                    last = (Map)temp;
                }
                continue;
            }
            result.put(fieldname, f.stringValue());
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

