/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene;

import bucket.search.Searcher;
import bucket.search.lucene.FilterCountingSearcher;
import bucket.search.lucene.LuceneException;
import bucket.search.lucene.LuceneUtils;
import bucket.search.lucene.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.LuceneConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneSearcher
implements Searcher {
    private static final Logger log = Logger.getLogger((Class)(class$bucket$search$lucene$LuceneSearcher == null ? (class$bucket$search$lucene$LuceneSearcher = LuceneSearcher.class$("bucket.search.lucene.LuceneSearcher")) : class$bucket$search$lucene$LuceneSearcher));
    private LuceneConnection luceneConnection;
    private LuceneAnalyzerFactory luceneAnalyzerFactory;
    private static final String[] HANDLE_ONLY_FIELDS = new String[]{"handle"};
    static /* synthetic */ Class class$bucket$search$lucene$LuceneSearcher;

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setLuceneAnalyzerFactory(LuceneAnalyzerFactory luceneAnalyzerFactory) {
        this.luceneAnalyzerFactory = luceneAnalyzerFactory;
    }

    public void setBooleanQueryMaxClause(int max) {
        BooleanQuery.setMaxClauseCount((int)max);
    }

    public Query buildStandardQuery(String[] searchFields, String query) {
        Query myquery = null;
        try {
            if (searchFields.length == 1) {
                QueryParser qp = new QueryParser(searchFields[0], this.luceneAnalyzerFactory.createAnalyzer());
                myquery = qp.parse(query);
            } else {
                myquery = MultiFieldQueryParser.parse((String)query, (String[])searchFields, (Analyzer)this.luceneAnalyzerFactory.createAnalyzer());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new LuceneException("Couldn't parse the query successfully:" + e.getMessage());
        }
        return myquery;
    }

    public Query buildStandardQuery(String defaultSearchField, String query) {
        return this.buildStandardQuery(new String[]{defaultSearchField}, query);
    }

    public List search(final Query myquery) {
        final LinkedList result = new LinkedList();
        this.luceneConnection.withSearch(new LuceneConnection.SearcherAction(){

            public boolean perform(IndexSearcher searcher) throws IOException {
                Hits hits = searcher.search(myquery);
                int x = hits.length();
                for (int i = 0; i < x; ++i) {
                    Document doc = hits.doc(i);
                    String handle = doc.get("handle");
                    result.add(handle);
                }
                return true;
            }
        });
        return result;
    }

    public Query rewrite(final Query query) {
        return (Query)this.luceneConnection.withReader(new LuceneConnection.ReaderAction(){

            public Object perform(IndexReader reader) throws IOException {
                return query.rewrite(reader);
            }
        });
    }

    public String explain(final Query myquery, final int docid) {
        final StringBuffer sb = new StringBuffer();
        this.luceneConnection.withSearch(new LuceneConnection.SearcherAction(){

            public boolean perform(IndexSearcher searcher) throws IOException {
                Explanation e = searcher.explain(myquery, docid);
                sb.append(e.toHtml());
                return true;
            }
        });
        return sb.toString();
    }

    public int searchCount(final Query myquery) {
        final int[] totalHits = new int[1];
        this.luceneConnection.withSearch(new LuceneConnection.SearcherAction(){

            public boolean perform(IndexSearcher searcher) throws IOException {
                searcher.search(myquery, new HitCollector(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void collect(int i, float v) {
                        int[] nArray = 4.access$000(this.this$1);
                        nArray[0] = nArray[0] + 1;
                    }
                });
                return false;
            }

            static /* synthetic */ int[] access$000(4 x0) {
                return x0.totalHits;
            }
        });
        return totalHits[0];
    }

    public List searchForFields(Query myquery, Set fieldsToExtract, int startIndex, int numItems) {
        return this.searchForFields(myquery, fieldsToExtract, startIndex, numItems, null, new int[1]);
    }

    public List searchForFields(final Query myquery, Set fieldsToExtract, final int startIndex, final int numItems, final Filter filter, final int[] filteredcount) {
        String[] fieldsToExtractArr = null;
        fieldsToExtractArr = fieldsToExtract != null && fieldsToExtract.size() > 0 ? fieldsToExtract.toArray(new String[fieldsToExtract.size()]) : HANDLE_ONLY_FIELDS;
        final String[] fieldsToExtractArr1 = fieldsToExtractArr;
        final ArrayList results = new ArrayList();
        this.luceneConnection.withSearch(new LuceneConnection.SearcherAction(){

            public boolean perform(IndexSearcher searcher) throws IOException {
                Hits hits = searcher.search(myquery, filter);
                if (searcher instanceof FilterCountingSearcher) {
                    FilterCountingSearcher dfss = (FilterCountingSearcher)searcher;
                    filteredcount[0] = dfss.getFilteredCount();
                    dfss.resetFilteredCount();
                }
                results.ensureCapacity(startIndex + numItems);
                int x = hits.length();
                for (int i = 0; i < x; ++i) {
                    HashMap<String, Integer> result;
                    if (i < startIndex || i >= startIndex + numItems) {
                        results.add(null);
                        continue;
                    }
                    Document doc = hits.doc(i);
                    if (fieldsToExtractArr1 == null) {
                        result = LuceneUtils.buildMapFromDocument(doc);
                    } else {
                        result = new HashMap<String, Integer>(fieldsToExtractArr1.length);
                        for (int j = 0; j < fieldsToExtractArr1.length; ++j) {
                            String fieldname = fieldsToExtractArr1[j];
                            result.put(fieldname, (Integer)((Object)doc.get(fieldname)));
                        }
                    }
                    result.put("docid", new Integer(hits.id(i)));
                    results.add(result);
                }
                return true;
            }
        });
        return results;
    }

    public List getAllFieldValues(final String fieldName) {
        return (List)this.luceneConnection.withReader(new LuceneConnection.ReaderAction(){

            public Object perform(IndexReader reader) throws IOException {
                ArrayList<String> values = new ArrayList<String>();
                TermEnum terms = reader.terms(new Term(fieldName, ""));
                do {
                    Term term;
                    if ((term = terms.term()) == null) continue;
                    if (!fieldName.equals(term.field())) break;
                    values.add(term.text());
                } while (terms.next());
                if (terms != null) {
                    terms.close();
                }
                return values;
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

