/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene;

import bucket.search.Indexer;
import bucket.search.Searchable;
import bucket.search.lucene.DocumentBuilder;
import com.atlassian.bonnie.LuceneConnection;
import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class LuceneIndexer
implements Indexer {
    public static final Category LOG = Category.getInstance((Class)(class$bucket$search$lucene$LuceneIndexer == null ? (class$bucket$search$lucene$LuceneIndexer = LuceneIndexer.class$("bucket.search.lucene.LuceneIndexer")) : class$bucket$search$lucene$LuceneIndexer));
    private LuceneConnection luceneConnection;
    private DocumentBuilder documentBuilder;
    static /* synthetic */ Class class$bucket$search$lucene$LuceneIndexer;

    public void index(final Searchable obj) {
        if (!obj.isIndexable()) {
            return;
        }
        this.unIndex(obj);
        this.luceneConnection.withWriter(new LuceneConnection.WriterAction(){

            public void perform(IndexWriter indexWriter) throws IOException {
                indexWriter.addDocument(LuceneIndexer.this.documentBuilder.getDocument(obj));
            }
        });
    }

    public void unIndex(final Searchable obj) {
        this.luceneConnection.withReaderAndDeletes(new LuceneConnection.ReaderAction(){

            public Object perform(IndexReader indexReader) throws IOException {
                Term t = new Term("handle", LuceneIndexer.this.documentBuilder.getHandleAttributeStringValue(obj));
                indexReader.delete(t);
                return null;
            }
        });
    }

    public void unIndexAll() {
        try {
            this.luceneConnection.truncateIndex();
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

