/*
 * Decompiled with CFR 0.152.
 */
package bucket.search.lucene;

import bucket.core.persistence.AnyTypeObjectDao;
import bucket.search.Searchable;
import bucket.search.lucene.DocumentBuilder;
import bucket.search.lucene.Extractor;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Hibernate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Category;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class BaseDocumentBuilder
implements DocumentBuilder {
    private static final Category log = Category.getInstance((Class)(class$bucket$search$lucene$BaseDocumentBuilder == null ? (class$bucket$search$lucene$BaseDocumentBuilder = BaseDocumentBuilder.class$("bucket.search.lucene.BaseDocumentBuilder")) : class$bucket$search$lucene$BaseDocumentBuilder));
    private AnyTypeObjectDao anyTypeObjectDao;
    static /* synthetic */ Class class$bucket$search$lucene$BaseDocumentBuilder;

    public Document getDocument(Searchable searchable) {
        Document document = this.getInitialDocument(searchable);
        StringBuffer contentBody = new StringBuffer();
        Iterator it = this.getExtractors().iterator();
        while (it.hasNext()) {
            Extractor extractor = (Extractor)it.next();
            extractor.addFields(document, contentBody, searchable);
        }
        if (contentBody.length() > 0) {
            document.add(Field.Text((String)"contentBody", (String)contentBody.toString()));
        }
        return document;
    }

    protected Document getInitialDocument(Searchable searchable) {
        Document document = new Document();
        String handleAttributeStringValue = this.getHandleAttributeStringValue(searchable);
        Field handleField = Field.Keyword((String)"handle", (String)handleAttributeStringValue);
        document.add(handleField);
        Field classNameField = new Field("classname", Hibernate.getClass((Object)searchable).getName(), false, true, false);
        document.add(classNameField);
        try {
            Object type = PropertyUtils.getProperty((Object)searchable, (String)"type");
            if (type != null) {
                document.add(Field.Keyword((String)"type", (String)type.toString()));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error getting metadata: Reason '" + e.getMessage() + "'"));
        }
        try {
            Object urlPath = PropertyUtils.getProperty((Object)searchable, (String)"urlPath");
            if (urlPath != null) {
                document.add(Field.Keyword((String)"urlPath", (String)urlPath.toString()));
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error getting metadata: Reason '" + e.getMessage() + "'"));
        }
        return document;
    }

    protected abstract List getExtractors();

    public String getHandleAttributeStringValue(Object obj) {
        return ((Object)this.anyTypeObjectDao.getHandle(obj)).toString();
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

