/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.persistence.hibernate.schema;

import bucket.config.ConfigurationException;
import bucket.core.persistence.hibernate.HibernateConfig;
import bucket.core.persistence.hibernate.MappingResources;
import java.util.List;
import java.util.Properties;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import net.sf.hibernate.tool.hbm2ddl.SchemaUpdate;

public class SchemaHelper {
    public static final String COMPONENT_REFERENCE = "schemaHelper";
    private Configuration configuration;
    private MappingResources mappingResources;
    private HibernateConfig hibernateConfig;
    private Properties hibernateConfigProperties;

    public void setHibernateProperties(Properties props) {
        this.hibernateConfigProperties = props;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }

    public Configuration getConfiguration() throws MappingException {
        if (this.configuration == null) {
            this.configuration = this.makeBaseHibernateConfiguration();
            if (this.mappingResources != null) {
                int n = this.mappingResources.getMappings().size();
                for (int i = 0; i < n; ++i) {
                    this.configuration.addResource((String)this.mappingResources.getMappings().get(i), Thread.currentThread().getContextClassLoader());
                }
            }
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public MappingResources getMappingResources() {
        return this.mappingResources;
    }

    public void setMappingResources(MappingResources mappings) {
        this.mappingResources = mappings;
    }

    public void addMappingResources(List mappings) {
        if (this.mappingResources == null) {
            this.mappingResources = new MappingResources();
        }
        this.mappingResources.setMappings(mappings);
    }

    public void recreateDatabase() throws ConfigurationException {
        this.createTables();
    }

    public void dropTables() throws ConfigurationException {
        try {
            new SchemaExport(this.getConfiguration()).drop(true, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", e);
        }
    }

    public void createTables() throws ConfigurationException {
        try {
            new SchemaExport(this.getConfiguration()).create(true, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", e);
        }
    }

    public void updateSchemaIfNeeded() throws ConfigurationException {
        this.updateSchemaIfNeeded(true);
    }

    public void updateSchemaIfNeeded(boolean showDDL) throws ConfigurationException {
        try {
            new SchemaUpdate(this.getConfiguration()).execute(showDDL, true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", e);
        }
    }

    private Configuration makeBaseHibernateConfiguration() {
        if (this.hibernateConfigProperties != null) {
            return new Configuration().setProperties(this.hibernateConfigProperties);
        }
        return new Configuration().setProperties(this.hibernateConfig.getHibernateProperties());
    }
}

