/*
 * Decompiled with CFR 0.152.
 */
package bucket.core.actions;

import java.util.List;

public class PaginationSupport {
    private List items;
    private int startIndex = 0;
    private int countOnEachPage;
    public static int DEFAULT_COUNT_ON_EACH_PAGE = 10;
    private int total = -1;

    public PaginationSupport() {
        this(DEFAULT_COUNT_ON_EACH_PAGE);
    }

    public PaginationSupport(int countOnEachPage) {
        if (countOnEachPage < 1) {
            throw new IllegalArgumentException("Count should be greater than zero!");
        }
        this.countOnEachPage = countOnEachPage;
    }

    public int getCountOnEachPage() {
        return this.countOnEachPage;
    }

    public List getItems() {
        return this.items;
    }

    public void setItems(List items) {
        this.items = items;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        int endIndex = this.getStartIndex() + this.countOnEachPage;
        if (endIndex > this.getTotal()) {
            return this.getTotal();
        }
        return endIndex;
    }

    public int getStartIndex() {
        if (this.startIndex > this.getTotal()) {
            return this.getTotal();
        }
        if (this.startIndex < 0) {
            return 0;
        }
        return this.startIndex;
    }

    public int getStartIndexValue() {
        return this.startIndex;
    }

    public int getNextIndex() {
        return this.getNextStartIndexes()[0];
    }

    public int getPreviousIndex() {
        int[] previousIndexes = this.getPreviousStartIndexes();
        return previousIndexes[previousIndexes.length - 1];
    }

    public int[] getNextStartIndexes() {
        int index = this.getEndIndex();
        if (index == this.getTotal()) {
            return null;
        }
        int count = (this.getTotal() - index) / this.countOnEachPage;
        if ((this.getTotal() - index) % this.countOnEachPage > 0) {
            ++count;
        }
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = index;
            index += this.countOnEachPage;
        }
        return result;
    }

    public int[] getPreviousStartIndexes() {
        int index = this.getStartIndex();
        if (index == 0) {
            return null;
        }
        int count = index / this.countOnEachPage;
        if (index % this.countOnEachPage > 0) {
            ++count;
        }
        int[] result = new int[count];
        for (int i = count - 1; i > 0; --i) {
            result[i] = index -= this.countOnEachPage;
        }
        return result;
    }

    public int getNiceStartIndex() {
        return this.getStartIndex() + 1;
    }

    public List getPage() {
        return this.getItems().subList(this.getStartIndex(), this.getEndIndex());
    }

    public int getTotal() {
        if (this.items != null) {
            return this.items.size();
        }
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }
}

