/*
 * Decompiled with CFR 0.152.
 */
package bucket.config;

import bucket.config.ApplicationConfiguration;
import bucket.config.ConfigurationException;
import bucket.config.ConfigurationPersister;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;

public class ApplicationConfig
implements ApplicationConfiguration {
    public static final Category log = Category.getInstance((Class)(class$bucket$config$ApplicationConfig == null ? (class$bucket$config$ApplicationConfig = ApplicationConfig.class$("bucket.config.ApplicationConfig")) : class$bucket$config$ApplicationConfig));
    public static final boolean NULL_BOOLEAN_VALUE = false;
    public static final int NULL_INTEGER_VALUE = Integer.MIN_VALUE;
    public static final String DEFAULT_CONFIG_FILE_NAME = "atlassian-config.xml";
    public static final String DEFAULT_APPLICATION_HOME = ".";
    private String applicationHome = ".";
    private boolean homeOk = false;
    private Map properties = new TreeMap();
    private String buildNumber = "0";
    private int majorVersion = 0;
    private int minorVersion = 0;
    private boolean setupComplete = false;
    protected ConfigurationPersister configurationPersister;
    static /* synthetic */ Class class$bucket$config$ApplicationConfig;

    public void reset() {
        this.homeOk = false;
        this.applicationHome = DEFAULT_APPLICATION_HOME;
        this.properties.clear();
        this.buildNumber = "0";
        this.majorVersion = 0;
        this.minorVersion = 0;
        this.setupComplete = false;
        this.configurationPersister = null;
    }

    public void setApplicationHome(String home) throws ConfigurationException {
        File homeDir = new File(home);
        if (!homeDir.isDirectory()) {
            log.warn((Object)("Application home does not exist. Creating directory: " + homeDir.getAbsolutePath()));
            this.homeOk = homeDir.mkdirs();
            if (!this.homeOk) {
                throw new ConfigurationException("Could not make directory/ies: " + homeDir.getAbsolutePath());
            }
        }
        try {
            this.applicationHome = homeDir.getCanonicalPath();
            this.homeOk = true;
        }
        catch (IOException e) {
            this.homeOk = false;
            throw new ConfigurationException("Failed to locate application home: " + home, e);
        }
    }

    public String getApplicationHome() {
        return this.applicationHome;
    }

    public boolean isApplicationHomeValid() {
        return this.homeOk;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setBuildNumber(String build) {
        this.buildNumber = build;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public String getApplicationVersion() {
        return this.getMajorVersion() + DEFAULT_APPLICATION_HOME + this.getMinorVersion() + " build: " + this.getBuildNumber();
    }

    public Map getPropertiesWithPrefix(String prefix) {
        HashMap newProps = new HashMap();
        Iterator iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            newProps.put(key, entry.getValue());
        }
        return newProps;
    }

    public boolean isSetupComplete() {
        return this.setupComplete;
    }

    public void setSetupComplete(boolean setupComplete) {
        this.setupComplete = setupComplete;
    }

    public void setProperty(Object key, int value) {
        this.properties.put(key, new Integer(value));
    }

    public void setProperty(Object key, boolean value) {
        this.properties.put(key, new Boolean(value));
    }

    public boolean getBooleanProperty(Object key) {
        Object temp = this.properties.get(key);
        if (temp == null) {
            return false;
        }
        if (temp instanceof Boolean) {
            return (Boolean)temp;
        }
        return Boolean.valueOf(temp.toString());
    }

    public int getIntegerProperty(Object key) {
        Object temp = this.properties.get(key);
        if (temp == null) {
            return Integer.MIN_VALUE;
        }
        if (temp instanceof Integer) {
            return (Integer)temp;
        }
        return Integer.valueOf(temp.toString());
    }

    public void save() throws ConfigurationException {
        this.configurationPersister.save(this.getApplicationHome(), this.getConfigurationFileName());
    }

    protected String getConfigurationFileName() {
        return DEFAULT_CONFIG_FILE_NAME;
    }

    public void setConfigurationPersister(ConfigurationPersister configurationPersister) {
        this.configurationPersister = configurationPersister;
    }

    public void setInitialProperties(Map initalProperties) {
        this.properties.putAll(initalProperties);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

