/*
 * Decompiled with CFR 0.152.
 */
package bucket.config;

import bucket.config.ConfigElement;
import bucket.config.ConfigurationException;
import bucket.config.ConfigurationPersister;
import bucket.util.ClassHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractConfigurationPersister
implements ConfigurationPersister {
    private Map configMappings = new HashMap();

    public void addConfigMapping(Class propertyType, Class configType) {
        this.configMappings.put(propertyType, configType);
    }

    public abstract Object getRootContext();

    public void addConfigElement(Object item, String propertyName) throws ConfigurationException {
        this.addConfigElement(item, propertyName, this.getRootContext());
    }

    public Object getConfigElement(Class propertyType, String propertyName) throws ConfigurationException {
        return this.getConfigElement(propertyType, propertyName, this.getRootContext());
    }

    public void addConfigElement(Object item, String propertyName, Object context) throws ConfigurationException {
        Class clazz = null;
        if (item == null) {
            return;
        }
        Iterator iterator = this.configMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Class c = (Class)entry.getKey();
            if (!c.isAssignableFrom(item.getClass())) continue;
            clazz = (Class)entry.getValue();
            break;
        }
        if (clazz != null) {
            try {
                ConfigElement config = (ConfigElement)ClassHelper.instantiateClass(clazz, new Object[]{propertyName, context, this});
                config.save(item);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create config element: " + clazz.getName(), e);
            }
        } else {
            throw new ConfigurationException("Failed to find config element for " + item.getClass().getName());
        }
    }

    public Object getConfigElement(Class propertyType, String propertyName, Object context) throws ConfigurationException {
        Class clazz = (Class)this.configMappings.get(propertyType);
        if (clazz != null) {
            try {
                ConfigElement config = (ConfigElement)ClassHelper.instantiateClass(clazz, new Object[]{propertyName, context, this});
                return config.load();
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create config element: " + clazz.getName(), e);
            }
        }
        throw new ConfigurationException("Failed to find config element for " + propertyType.getName());
    }
}

