/*
 * Decompiled with CFR 0.152.
 */
package bucket.cache;

import bucket.cache.CacheManager;
import bucket.cache.ehcache.Ehcache;
import bucket.core.InfrastructureException;
import com.atlassian.user.impl.cache.Cache;
import com.opensymphony.user.UserManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Category;
import org.springframework.beans.factory.InitializingBean;

public class DefaultCacheManager
implements InitializingBean,
CacheManager {
    private static final Category log = Category.getInstance((Class)(class$bucket$cache$DefaultCacheManager == null ? (class$bucket$cache$DefaultCacheManager = DefaultCacheManager.class$("bucket.cache.DefaultCacheManager")) : class$bucket$cache$DefaultCacheManager));
    private List nonFlushableCaches = new ArrayList();
    net.sf.ehcache.CacheManager ehcacheManager;
    static /* synthetic */ Class class$bucket$cache$DefaultCacheManager;

    public void afterPropertiesSet() throws Exception {
        this.ehcacheManager = net.sf.ehcache.CacheManager.create();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created ehcache : " + this.ehcacheManager));
            for (int i = 0; i < this.ehcacheManager.getCacheNames().length; ++i) {
                String s = this.ehcacheManager.getCacheNames()[i];
                log.debug((Object)("Found cache = " + s));
            }
        }
    }

    public Cache getCache(String name) {
        if (!this.ehcacheManager.cacheExists(name)) {
            try {
                log.warn((Object)("Cache named " + name + " was not in ehcache.xml. Using default settings."));
                this.ehcacheManager.addCache(name);
            }
            catch (CacheException e) {
                throw new InfrastructureException(e);
            }
        }
        return new Ehcache(this.ehcacheManager.getCache(name));
    }

    public void flushCache(String name) {
        if (!this.ehcacheManager.cacheExists(name)) {
            log.warn((Object)("Cache named " + name + " does not exist."));
            return;
        }
        try {
            this.getCache(name).removeAll();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void flushCaches() {
        if (UserManager.getInstance() != null) {
            UserManager.getInstance().flushCaches();
        }
        for (int i = 0; i < this.ehcacheManager.getCacheNames().length; ++i) {
            String cacheName = this.ehcacheManager.getCacheNames()[i];
            try {
                if (this.nonFlushableCaches.contains(cacheName)) continue;
                this.ehcacheManager.getCache(cacheName).removeAll();
                continue;
            }
            catch (IOException e) {
                log.error((Object)("Could not remove cache contents: " + e), (Throwable)e);
            }
        }
    }

    public void flushCache(String cacheName, Serializable key) {
        try {
            this.getCache(cacheName).remove((Object)key);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void put(String cacheName, Serializable key, Serializable value) {
        this.getCache(cacheName).put((Object)key, (Object)value);
    }

    public Serializable get(String cacheName, Serializable key) {
        return (Serializable)this.getCache(cacheName).get((Object)key);
    }

    public void setNonFlushableCaches(List nonFlushableCaches) {
        this.nonFlushableCaches = nonFlushableCaches;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

