/*
 * Decompiled with CFR 0.152.
 */
package bucket.admin.actions;

import bucket.admin.actions.AbstractUsersAction;
import com.opensymphony.util.TextUtils;

public class SetUserPasswordAction
extends AbstractUsersAction {
    private String newPassword;
    private String newPasswordConfirmation;

    public void validate() {
        if (!TextUtils.stringSet((String)this.newPassword)) {
            this.addFieldError("newPassword", this.getText("new.password.required"));
        } else if (!this.newPassword.equals(this.newPasswordConfirmation)) {
            this.addActionError(this.getText("passwords.dont.match"));
        }
    }

    public String execute() throws Exception {
        if (this.user == null) {
            this.user = this.getUser();
        }
        this.userAccessor.alterPassword(this.user, this.newPassword);
        this.userAccessor.saveUser(this.user);
        return "success";
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getNewPasswordConfirmation() {
        return this.newPasswordConfirmation;
    }

    public void setNewPasswordConfirmation(String newPasswordConfirmation) {
        this.newPasswordConfirmation = newPasswordConfirmation;
    }
}

