/*
 * Decompiled with CFR 0.152.
 */
package bucket.admin.actions;

import bucket.admin.actions.AbstractGroupAction;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.opensymphony.util.TextUtils;
import java.util.Iterator;
import java.util.List;

public class RemoveGroupAction
extends AbstractGroupAction {
    String confirm;
    String moveTo = "-1";

    public void validate() {
        if (!TextUtils.stringSet((String)this.getName())) {
            this.addActionError(this.getText("name.empty"));
        } else if (this.getGroup() == null) {
            this.addActionError(this.getText("group.doesnt.exist"));
        }
    }

    public String doDefault() throws Exception {
        Pager adminGroups = this.userAccessor.getGroups();
        if (this.userAccessor.getGroup(this.getName()) != null && PagerUtils.count((Pager)adminGroups) == 1) {
            this.addActionError("You cannot remove the last group with ADMINISTRATE permission");
        }
        return "input";
    }

    public String execute() throws Exception {
        if (TextUtils.stringSet((String)this.confirm)) {
            if (!this.getMoveTo().equals("-1")) {
                Group group = this.userAccessor.getGroup(this.getMoveTo());
                Iterator iterator = this.getUsers().iterator();
                while (iterator.hasNext()) {
                    this.userAccessor.addMembership(group.getName(), (String)iterator.next());
                }
            }
            this.userAccessor.removeGroup(this.getGroup());
        }
        return "success";
    }

    public List getGroups() {
        List result = super.getGroups();
        result.remove(this.getGroup());
        return result;
    }

    public Pager getUsers() {
        return this.userAccessor.getMemberNames(this.getGroup());
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getMoveTo() {
        return this.moveTo;
    }

    public void setMoveTo(String moveTo) {
        this.moveTo = moveTo;
    }
}

