/*
 * Decompiled with CFR 0.152.
 */
package bucket.admin.actions;

import bucket.admin.actions.AbstractUsersAction;
import bucket.container.ContainerManager;
import com.atlassian.user.Group;
import com.atlassian.user.search.page.Pager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class EditUserGroupsAction
extends AbstractUsersAction {
    private Pager memberGroupsIter;
    private List nonMemberGroups;
    private String action;
    private List groupsToJoin;
    private List groupsToLeave;

    public String doDefault() throws Exception {
        this.loadLists();
        return "input";
    }

    private void loadLists() {
        this.memberGroupsIter = this.userAccessor.getGroups(this.getUser());
        Iterator iter = this.userAccessor.getGroups().iterator();
        this.nonMemberGroups = new ArrayList();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            if (this.userAccessor.hasMembership(group, this.getUser())) continue;
            this.nonMemberGroups.add(group.getName());
        }
    }

    public String execute() throws Exception {
        String groupname;
        Iterator iterator;
        if ("join".equalsIgnoreCase(this.action) && this.groupsToJoin != null) {
            iterator = this.groupsToJoin.iterator();
            while (iterator.hasNext()) {
                groupname = (String)iterator.next();
                Group group = this.userAccessor.getGroup(groupname);
                if (group == null || this.userAccessor.hasMembership(group, this.getUser())) continue;
                this.userAccessor.addMembership(group, this.getUser());
            }
        } else if ("leave".equalsIgnoreCase(this.action) && this.groupsToLeave != null) {
            iterator = this.groupsToLeave.iterator();
            while (iterator.hasNext()) {
                groupname = (String)iterator.next();
                Group group = this.userAccessor.getGroup(groupname);
                if (group == null || !this.userAccessor.hasMembership(group, this.getUser())) continue;
                this.userAccessor.removeMembership(group, this.getUser());
            }
        }
        if (ContainerManager.getInstance().getContainerContext() != null) {
            SessionFactory factory = (SessionFactory)ContainerManager.getInstance().getContainerContext().getComponent("sessionFactory");
            Session session = SessionFactoryUtils.getSession((SessionFactory)factory, (boolean)false);
            session.flush();
        }
        this.loadLists();
        return super.execute();
    }

    public Pager getMemberGroupsIter() {
        return this.memberGroupsIter;
    }

    public List getNonMemberGroups() {
        return this.nonMemberGroups;
    }

    public void setGroupsToJoin(List toJoin) {
        this.groupsToJoin = toJoin;
    }

    public void setGroupsToLeave(List toLeave) {
        this.groupsToLeave = toLeave;
    }

    public void setJoin(String action) {
        this.action = "join";
    }

    public void setLeave(String x) {
        this.action = "leave";
    }
}

