/*
 * Decompiled with CFR 0.152.
 */
package bucket.admin.actions;

import bucket.admin.actions.AbstractUsersAction;
import bucket.user.LicensingException;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;

public class CreateUserAction
extends AbstractUsersAction {
    private String password;
    private String confirm;
    private String email;
    private String fullname;

    public void validate() {
        if (!TextUtils.stringSet((String)this.username)) {
            this.addFieldError("username", this.getText("username.empty"));
        } else if (this.userAccessor.getUser(this.username) != null) {
            this.addActionError(this.getText("user.exists"));
        }
        if (!TextUtils.stringSet((String)this.fullname)) {
            this.addFieldError("fullname", this.getText("fullname.empty"));
        }
        if (!TextUtils.stringSet((String)this.password)) {
            this.addFieldError("password", this.getText("password.empty"));
        } else if (!this.password.equals(this.confirm)) {
            this.addActionError(this.getText("passwords.dontmatch"));
        }
        if (!TextUtils.verifyEmail((String)this.email)) {
            this.addFieldError("email", this.getText("email.invalid"));
        }
    }

    public String doDefault() throws Exception {
        if (!this.userAccessor.isLicensedToAddMoreUsers()) {
            this.addActionError("Your license ");
        }
        return super.doDefault();
    }

    public String execute() throws Exception {
        try {
            User user = this.userAccessor.addUser(this.username, this.password, this.email, this.fullname);
            this.userAccessor.addMembership(this.userAccessor.getDefaultGroup(), user);
        }
        catch (LicensingException e) {
            this.addActionError(e.getMessage());
            return "error";
        }
        return "success";
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}

