/*
 * Decompiled with CFR 0.152.
 */
package bucket.admin.actions;

import bucket.admin.actions.AbstractUsersAction;
import bucket.core.actions.PagerPaginationSupport;
import bucket.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.Query;

public class BrowseUsersAction
extends AbstractUsersAction {
    private PagerPaginationSupport paginationSupport = new PagerPaginationSupport(50);
    private Query query;
    protected static final int DEFAULT_USERS_PER_PAGE = 50;
    protected boolean viewAll;
    private boolean reset;
    private Pager groups;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public String execute() throws Exception {
        if (this.reset) {
            this.query = null;
        }
        this.getUsers();
        return "success";
    }

    public Pager getUsers() throws Exception {
        Pager users = null;
        if (this.paginationSupport.getItems() == null && (users = this.retrieveUsers(this.userAccessor)) != null) {
            this.paginationSupport.setItems(users);
        }
        return this.paginationSupport.getItems();
    }

    public Pager retrieveUsers(UserAccessor userAccessor) throws EntityException {
        if (this.isViewAll()) {
            if (this.query == null) {
                return userAccessor.findUsers(this.query).pager();
            }
            return userAccessor.getUserNames();
        }
        if (this.query != null) {
            return userAccessor.findUsers(this.query).pager();
        }
        return null;
    }

    public PagerPaginationSupport getPaginationSupport() {
        return this.paginationSupport;
    }

    public void setStartIndex(int startIndex) {
        this.paginationSupport.setStartIndex(startIndex);
    }

    public Pager getGroups() {
        if (this.groups == null) {
            this.groups = this.userAccessor.getGroups();
        }
        return this.groups;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReset() {
        return this.reset;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public boolean isDeactivated(User user) {
        return this.userAccessor.getPropertySet(user).getBoolean("confluence.user.deactivated");
    }

    public boolean isViewAll() {
        return this.viewAll;
    }

    public void setViewAll(boolean viewAll) {
        this.viewAll = viewAll;
    }

    public void setQuery(Query query) {
        this.query = query;
    }
}

