/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.xmlrpc;

import bucket.core.InfrastructureException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.xmlrpc.ConfluenceXmlRpcHandler;
import com.atlassian.confluence.rpc.xmlrpc.Translator;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Category;

public class ConfluenceXmlRpcHandlerImpl
implements ConfluenceXmlRpcHandler {
    public static final Category log = Category.getInstance((Class)(class$com$atlassian$confluence$rpc$xmlrpc$ConfluenceXmlRpcHandlerImpl == null ? (class$com$atlassian$confluence$rpc$xmlrpc$ConfluenceXmlRpcHandlerImpl = ConfluenceXmlRpcHandlerImpl.class$("com.atlassian.confluence.rpc.xmlrpc.ConfluenceXmlRpcHandlerImpl")) : class$com$atlassian$confluence$rpc$xmlrpc$ConfluenceXmlRpcHandlerImpl));
    ConfluenceSoapService soapServiceDelegator;
    static /* synthetic */ Class class$com$atlassian$confluence$rpc$xmlrpc$ConfluenceXmlRpcHandlerImpl;

    public void setSoapServiceDelegator(ConfluenceSoapService confluenceSoapService) {
        this.soapServiceDelegator = confluenceSoapService;
    }

    public String login(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.login(string, string2);
    }

    public boolean logout(String string) throws RemoteException {
        return this.soapServiceDelegator.logout(string);
    }

    public Vector getSpaces(String string) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpaces(string));
    }

    public Vector getBlogEntries(String string, String string2) throws RemoteException {
        try {
            return Translator.makeVector((Object[])this.soapServiceDelegator.getBlogEntries(string, string2));
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            throw new RemoteException((Throwable)exception);
        }
    }

    public Hashtable getBlogEntryByDayAndTitle(String string, String string2, int n, String string3) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getBlogEntryByDayAndTitle(string, string2, n, string3));
    }

    public Vector getComments(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getComments(string, this.makePageId(string2)));
    }

    public Hashtable getComment(String string, String string2) throws InvalidSessionException, RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getComment(string, Long.parseLong(string2)));
    }

    public Hashtable addComment(String string, Hashtable hashtable) throws InvalidSessionException, NotPermittedException, RemoteException {
        RemoteComment remoteComment = new RemoteComment();
        hashtable.remove("created");
        this.convertLong(hashtable, "id");
        this.convertLong(hashtable, "pageId");
        try {
            BeanUtils.populate((Object)remoteComment, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn((Object)("Unable to add comment via XML-RPC: " + illegalAccessException.getMessage()), (Throwable)illegalAccessException);
            throw new InfrastructureException("Unable to add comment: " + illegalAccessException.toString(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addComment(string, remoteComment));
    }

    public boolean removeComment(String string, String string2) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeComment(string, Long.parseLong(string2));
    }

    public Vector getAncestors(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getAncestors(string, this.makePageId(string2)));
    }

    public Vector getChildren(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getChildren(string, this.makePageId(string2)));
    }

    public Vector getDescendents(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getDescendents(string, this.makePageId(string2)));
    }

    public Vector getAttachments(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getAttachments(string, this.makePageId(string2)));
    }

    public Hashtable getBlogEntry(String string, String string2) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getBlogEntry(string, this.makePageId(string2)));
    }

    public Vector getPages(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPages(string, string2));
    }

    public Hashtable getPage(String string, String string2) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getPage(string, this.makePageId(string2)));
    }

    public Hashtable getPage(String string, String string2, String string3) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getPage(string, string2, string3));
    }

    public Vector getPageHistory(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPageHistory(string, this.makePageId(string2)));
    }

    public Hashtable getSpace(String string, String string2) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getSpace(string, string2));
    }

    public Vector getPermissions(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPermissions(string, string2));
    }

    public Vector getPermissionsForUser(String string, String string2, String string3) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPermissionsForUser(string, string2, string3));
    }

    public Vector getPagePermissions(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getPagePermissions(string, this.makePageId(string2)));
    }

    private long makePageId(String string) throws RemoteException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RemoteException("You must supply a valid number as the page ID.");
        }
    }

    public String renderContent(String string, String string2, String string3, String string4) throws RemoteException {
        return this.soapServiceDelegator.renderContent(string, string2, this.makePageId(string3), string4);
    }

    public String renderContent(String string, String string2, String string3, String string4, Hashtable hashtable) throws RemoteException {
        return this.soapServiceDelegator.renderContent(string, string2, this.makePageId(string3), string4, hashtable);
    }

    public Boolean removePage(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.removePage(string, this.makePageId(string2));
    }

    public Vector search(String string, String string2, int n) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.search(string, string2, n));
    }

    public Vector search(String string, String string2, Hashtable hashtable, int n) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.search(string, string2, hashtable, n));
    }

    public Hashtable storeBlogEntry(String string, Hashtable hashtable) throws RemoteException {
        RemoteBlogEntry remoteBlogEntry = new RemoteBlogEntry();
        this.convertLong(hashtable, "id");
        this.convertInteger(hashtable, "version");
        hashtable.remove("publishDate");
        try {
            BeanUtils.populate((Object)remoteBlogEntry, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InfrastructureException("Bad error :)", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.storeBlogEntry(string, remoteBlogEntry));
    }

    private void convertLong(Hashtable hashtable, String string) {
        if (hashtable.containsKey(string)) {
            hashtable.put(string, new Long((String)hashtable.get(string)));
        }
    }

    private void convertDate(Hashtable hashtable, String string) {
        if (hashtable.containsKey(string)) {
            String string2 = (String)hashtable.get(string);
            try {
                Date date = SimpleDateFormat.getDateInstance().parse(string2);
                hashtable.put(string, date);
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Error parsing date '" + string2 + "'", parseException);
            }
        }
    }

    private void convertInteger(Hashtable hashtable, String string) {
        if (hashtable.containsKey(string)) {
            hashtable.put(string, new Integer((String)hashtable.get(string)));
        }
    }

    public Hashtable storePage(String string, Hashtable hashtable) throws RemoteException {
        RemotePage remotePage = new RemotePage();
        this.convertLong(hashtable, "id");
        if (hashtable.containsKey("parentId")) {
            hashtable.put("parentId", new Long((String)hashtable.get("parentId")));
        }
        if (hashtable.containsKey("version")) {
            hashtable.put("version", new Integer((String)hashtable.get("version")));
        }
        hashtable.remove("modified");
        hashtable.remove("created");
        try {
            BeanUtils.populate((Object)remotePage, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InfrastructureException("Bad error :)", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.storePage(string, remotePage));
    }

    private String getRequiredStringParameter(Hashtable hashtable, String string) {
        if (!hashtable.containsKey(string)) {
            throw new RuntimeException("No '" + string + "' specified.");
        }
        return (String)hashtable.get(string);
    }

    public Hashtable addAttachment(String string, String string2, Hashtable hashtable, byte[] byArray) throws RemoteException {
        RemoteAttachment remoteAttachment = new RemoteAttachment(Long.parseLong(string2), this.getRequiredStringParameter(hashtable, "fileName"), this.getRequiredStringParameter(hashtable, "contentType"), (String)hashtable.get("comment"));
        return Translator.makeStruct((Object)this.soapServiceDelegator.addAttachment(string, Long.parseLong(string2), remoteAttachment, byArray));
    }

    public Hashtable getAttachment(String string, String string2, String string3, String string4) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getAttachment(string, Long.parseLong(string2), string3, Integer.parseInt(string4)));
    }

    public byte[] getAttachmentData(String string, String string2, String string3, String string4) throws RemoteException {
        return this.soapServiceDelegator.getAttachmentData(string, Long.parseLong(string2), string3, Integer.parseInt(string4));
    }

    public boolean removeAttachment(String string, String string2, String string3) throws RemoteException, NotPermittedException {
        return this.soapServiceDelegator.removeAttachment(string, Long.parseLong(string2), string3);
    }

    public boolean moveAttachment(String string, String string2, String string3, String string4, String string5) throws RemoteException, NotPermittedException {
        return this.soapServiceDelegator.moveAttachment(string, Long.parseLong(string2), string3, Long.parseLong(string4), string5);
    }

    public Hashtable addSpace(String string, Hashtable hashtable) throws RemoteException {
        RemoteSpace remoteSpace = new RemoteSpace();
        try {
            BeanUtils.populate((Object)remoteSpace, (Map)hashtable);
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to create space via XML-RPC: " + exception.getMessage()), (Throwable)exception);
            throw new InfrastructureException("Unable to create space: " + exception.toString(), (Throwable)exception);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addSpace(string, remoteSpace));
    }

    public Hashtable addPersonalSpace(String string, Hashtable hashtable, String string2) throws RemoteException {
        RemoteSpace remoteSpace = new RemoteSpace();
        try {
            BeanUtils.populate((Object)remoteSpace, (Map)hashtable);
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to create space via XML-RPC: " + exception.getMessage()), (Throwable)exception);
            throw new InfrastructureException("Unable to create space: " + exception.toString(), (Throwable)exception);
        }
        return Translator.makeStruct((Object)this.soapServiceDelegator.addPersonalSpace(string, remoteSpace, string2));
    }

    public boolean convertToPersonalSpace(String string, String string2, String string3, String string4, boolean bl) throws RemoteException {
        return this.soapServiceDelegator.convertToPersonalSpace(string, string2, string3, string4, bl);
    }

    public Boolean removeSpace(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.removeSpace(string, string2);
    }

    public String exportSpace(String string, String string2, String string3) throws RemoteException {
        return this.soapServiceDelegator.exportSpace(string, string2, string3);
    }

    public boolean addPermissionToSpace(String string, String string2, String string3, String string4) throws RemoteException {
        return this.soapServiceDelegator.addPermissionToSpace(string, string2, string3, string4);
    }

    public boolean addPermissionsToSpace(String string, Vector vector, String string2, String string3) throws RemoteException {
        return this.soapServiceDelegator.addPermissionsToSpace(string, this.convertPermissionsVectorToArray(vector), string2, string3);
    }

    private String[] convertPermissionsVectorToArray(Vector vector) throws RemoteException {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof String)) {
                throw new RemoteException("Unable to add permissions to Space: Permissions must be Strings");
            }
            stringArray[i] = (String)e;
        }
        return stringArray;
    }

    public boolean removePermissionFromSpace(String string, String string2, String string3, String string4) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removePermissionFromSpace(string, string2, string3, string4);
    }

    public boolean addAnonymousPermissionToSpace(String string, String string2, String string3) throws RemoteException {
        return this.soapServiceDelegator.addAnonymousPermissionToSpace(string, string2, string3);
    }

    public boolean addAnonymousPermissionsToSpace(String string, Vector vector, String string2) throws RemoteException {
        return this.soapServiceDelegator.addAnonymousPermissionsToSpace(string, this.convertPermissionsVectorToArray(vector), string2);
    }

    public boolean removeAnonymousPermissionFromSpace(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeAnonymousPermissionFromSpace(string, string2, string3);
    }

    public String[] getSpaceLevelPermissions(String string) throws RemoteException {
        return this.soapServiceDelegator.getSpaceLevelPermissions(string);
    }

    public Hashtable getServerInfo(String string) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getServerInfo(string));
    }

    public String exportSite(String string, boolean bl) throws RemoteException {
        return this.soapServiceDelegator.exportSite(string, bl);
    }

    public boolean flushIndexQueue(String string) throws RemoteException {
        return this.soapServiceDelegator.flushIndexQueue(string);
    }

    public boolean clearIndexQueue(String string) throws RemoteException {
        return this.soapServiceDelegator.clearIndexQueue(string);
    }

    public Vector getGroups(String string) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getGroups(string));
    }

    public boolean hasGroup(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.hasGroup(string, string2);
    }

    public boolean addGroup(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.addGroup(string, string2);
    }

    public boolean removeGroup(String string, String string2, String string3) throws RemoteException {
        return this.soapServiceDelegator.removeGroup(string, string2, string3);
    }

    public Vector getUserGroups(String string, String string2) throws RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getUserGroups(string, string2));
    }

    public boolean addUserToGroup(String string, String string2, String string3) throws RemoteException {
        this.soapServiceDelegator.addUserToGroup(string, string2, string3);
        return true;
    }

    public boolean removeAllPermissionsForGroup(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.removeAllPermissionsForGroup(string, string2);
    }

    public boolean removeUserFromGroup(String string, String string2, String string3) throws RemoteException {
        return this.soapServiceDelegator.removeUserFromGroup(string, string2, string3);
    }

    public Hashtable getUser(String string, String string2) throws RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getUser(string, string2));
    }

    public boolean hasUser(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.hasUser(string, string2);
    }

    public boolean addUser(String string, Hashtable hashtable, String string2) throws RemoteException {
        RemoteUser remoteUser = new RemoteUser();
        try {
            BeanUtils.populate((Object)remoteUser, (Map)hashtable);
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to create user via XML-RPC: " + exception.getMessage()), (Throwable)exception);
            throw new InfrastructureException("Unable to create user: " + exception.toString(), (Throwable)exception);
        }
        this.soapServiceDelegator.addUser(string, remoteUser, string2);
        return true;
    }

    public boolean removeUser(String string, String string2) throws RemoteException {
        return this.soapServiceDelegator.removeUser(string, string2);
    }

    public boolean editUser(String string, Hashtable hashtable) throws NotPermittedException, InvalidSessionException, RemoteException {
        RemoteUser remoteUser = new RemoteUser();
        try {
            BeanUtils.populate((Object)remoteUser, (Map)hashtable);
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to edit user via XML-RPC: " + exception.getMessage()), (Throwable)exception);
            throw new InfrastructureException("Unable to edit user: " + exception.toString(), (Throwable)exception);
        }
        return this.soapServiceDelegator.editUser(string, remoteUser);
    }

    public boolean deactivateUser(String string, String string2) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.deactivateUser(string, string2);
    }

    public boolean reactivateUser(String string, String string2) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.reactivateUser(string, string2);
    }

    public Vector getActiveUsers(String string, boolean bl) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getActiveUsers(string, bl));
    }

    public boolean setUserInformation(String string, Hashtable hashtable) throws NotPermittedException, InvalidSessionException, RemoteException {
        RemoteUserInformation remoteUserInformation = new RemoteUserInformation();
        if (hashtable.containsKey("id")) {
            hashtable.put("id", new Long((String)hashtable.get("id")));
        }
        if (hashtable.containsKey("version")) {
            hashtable.put("version", new Integer((String)hashtable.get("version")));
        }
        hashtable.remove("creationDate");
        hashtable.remove("lastModificationDate");
        try {
            BeanUtils.populate((Object)remoteUserInformation, (Map)hashtable);
        }
        catch (Exception exception) {
            log.warn((Object)("Unable to edit user information via XML-RPC: " + exception.getMessage()), (Throwable)exception);
            throw new InfrastructureException("Unable to edit user information: " + exception.toString(), (Throwable)exception);
        }
        return this.soapServiceDelegator.setUserInformation(string, remoteUserInformation);
    }

    public Hashtable getUserInformation(String string, String string2) throws InvalidSessionException, RemoteException {
        return Translator.makeStruct((Object)this.soapServiceDelegator.getUserInformation(string, string2));
    }

    public boolean changeMyPassword(String string, String string2, String string3) throws InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.changeMyPassword(string, string2, string3);
    }

    public boolean changeUserPassword(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.changeUserPassword(string, string2, string3);
    }

    public boolean addProfilePicture(String string, String string2, String string3, String string4, byte[] byArray) throws RemoteException {
        return this.soapServiceDelegator.addProfilePicture(string, string2, string3, string4, byArray);
    }

    public Vector getLabelsById(String string, String string2) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelsById(string, this.makePageId(string2)));
    }

    public Vector getMostPopularLabels(String string, int n) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getMostPopularLabels(string, n));
    }

    public Vector getMostPopularLabelsInSpace(String string, String string2, int n) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getMostPopularLabelsInSpace(string, string2, n));
    }

    public Vector getLabelContentById(String string, String string2) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentById(string, Long.parseLong(string2)));
    }

    public Vector getLabelContentByName(String string, String string2) throws NotPermittedException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentByName(string, string2));
    }

    public Vector getLabelContentByObject(String string, Hashtable hashtable) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(hashtable, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelContentByObject(string, remoteLabel));
    }

    public Vector getRecentlyUsedLabels(String string, int n) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRecentlyUsedLabels(string, n));
    }

    public Vector getRecentlyUsedLabelsInSpace(String string, String string2, int n) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRecentlyUsedLabelsInSpace(string, string2, n));
    }

    public Vector getSpacesWithLabel(String string, String string2) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpacesWithLabel(string, string2));
    }

    public Vector getRelatedLabels(String string, String string2, int n) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRelatedLabels(string, string2, n));
    }

    public Vector getRelatedLabelsInSpace(String string, String string2, String string3, int n) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getRelatedLabelsInSpace(string, string2, string3, n));
    }

    public Vector getLabelsByDetail(String string, String string2, String string3, String string4, String string5) throws InvalidSessionException, RemoteException, NotPermittedException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getLabelsByDetail(string, string2, string3, string4, string5));
    }

    public Vector getSpacesContainingContentWithLabel(String string, String string2) throws InvalidSessionException, RemoteException {
        return Translator.makeVector((Object[])this.soapServiceDelegator.getSpacesContainingContentWithLabel(string, string2));
    }

    public boolean addLabelByName(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.addLabelByName(string, string2, Long.parseLong(string3));
    }

    public boolean addLabelById(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.addLabelById(string, Long.parseLong(string2), Long.parseLong(string3));
    }

    public boolean addLabelByObject(String string, Hashtable hashtable, String string2) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(hashtable, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return this.soapServiceDelegator.addLabelByObject(string, remoteLabel, Long.parseLong(string2));
    }

    public boolean addLabelByNameToSpace(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.addLabelByNameToSpace(string, string2, string3);
    }

    public boolean removeLabelByName(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeLabelByName(string, string2, Long.parseLong(string3));
    }

    public boolean removeLabelById(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.soapServiceDelegator.removeLabelById(string, Long.parseLong(string2), Long.parseLong(string3));
    }

    public boolean removeLabelByObject(String string, Hashtable hashtable, String string2) throws NotPermittedException, RemoteException {
        RemoteLabel remoteLabel = new RemoteLabel();
        this.convertLong(hashtable, "id");
        try {
            BeanUtils.populate((Object)remoteLabel, (Map)hashtable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InfrastructureException("Error in populating RemoteLabel bean", (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return this.soapServiceDelegator.removeLabelByObject(string, remoteLabel, Long.parseLong(string2));
    }

    public boolean removeLabelByNameFromSpace(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.soapServiceDelegator.removeLabelByNameFromSpace(string, string2, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

