/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserContentManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.ProfilePicture;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class UsersSoapService {
    UserAccessor userAccessor;
    SpacePermissionManager spacePermissionManager;
    PermissionManager permissionManager;
    SoapServiceHelper soapServiceHelper;
    SpaceManager spaceManager;
    PersonalInformationManager personalInformationManager;
    AttachmentManager attachmentManager;
    private UserContentManager userContentManager;

    public void setUserContentManager(UserContentManager userContentManager) {
        this.userContentManager = userContentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private boolean canUserAdminister(User user) {
        return GeneralUtil.isSuperUser((User)user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, null);
    }

    public RemoteUser getUser(String string) throws RemoteException {
        return new RemoteUser(this.retrieveUser(string));
    }

    private User retrieveUser(String string) throws RemoteException {
        User user = this.userAccessor.getUser(string);
        if (user == null) {
            throw new RemoteException("No user with that username found.");
        }
        return user;
    }

    public boolean addUser(RemoteUser remoteUser, String string) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        this.userAccessor.addUser(remoteUser.getName(), string, remoteUser.getEmail(), remoteUser.getFullname(), new String[]{"confluence-users"});
        return true;
    }

    public boolean removeUser(String string) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        if (this.userContentManager.hasAuthoredContent(user)) {
            throw new RemoteException("cannot remove user because he has authored content");
        }
        Space space = this.spaceManager.getPersonalSpace(user);
        if (space != null) {
            this.spaceManager.removeSpace(space);
        }
        this.userAccessor.removeUser(user);
        return true;
    }

    public boolean editUser(RemoteUser remoteUser) throws NotPermittedException, RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        User user2 = this.retrieveUser(remoteUser.getName());
        boolean bl = false;
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)user2)) {
            throw new NotPermittedException("You are not logged in as the correct user, or you do not have the correct permissions to perform this action.");
        }
        if (!user2.getName().equals(remoteUser.getName())) {
            throw new RemoteException("Cannot change the username");
        }
        if (!user2.getFullName().equals(remoteUser.getFullname())) {
            bl = true;
            user2.setFullName(remoteUser.getFullname());
        }
        if (!user2.getEmail().equals(remoteUser.getEmail())) {
            bl = true;
            user2.setEmail(remoteUser.getEmail());
        }
        if (bl) {
            this.userAccessor.saveUser(user2);
        }
        return true;
    }

    public String[] getUserGroups(String string) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        Pager pager = this.userAccessor.getGroups(user);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = pager.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            arrayList.add(group.getName());
        }
        return arrayList.toArray(new String[1]);
    }

    public boolean addUserToGroup(String string, String string2) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        Group group = this.userAccessor.getGroup(string2);
        if (group == null) {
            throw new RemoteException("The group specified does not exist.");
        }
        this.userAccessor.addMembership(group, user);
        return true;
    }

    public boolean removeUserFromGroup(String string, String string2) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        Group group = this.userAccessor.getGroup(string2);
        if (group == null) {
            throw new RemoteException("The group specified does not exist.");
        }
        this.userAccessor.removeMembership(group, user);
        return true;
    }

    public boolean addGroup(String string) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        if (this.userAccessor.getGroup(string) == null) {
            this.userAccessor.addGroup(string);
            return true;
        }
        return false;
    }

    public boolean removeAllPermissionsForGroup(String string) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        Group group = this.userAccessor.getGroup(string);
        if (group == null) {
            throw new RemoteException("cannot delete permissions for non existing group");
        }
        this.spacePermissionManager.removeAllPermissionsForGroup(string);
        return true;
    }

    public boolean removeGroup(String string, String string2) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        Group group = this.userAccessor.getGroup(string);
        if (group == null) {
            throw new RemoteException("cannot remove non existing group");
        }
        boolean bl = false;
        Group group2 = null;
        if (string2 != null && string2.length() != 0) {
            group2 = this.userAccessor.getGroup(string2);
            if (group2 == null) {
                throw new RemoteException("default group does not exist");
            }
            bl = true;
        }
        Iterator iterator = this.userAccessor.getMemberNames(group).iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!bl) continue;
            this.userAccessor.addMembership(group2.getName(), string3);
        }
        this.userAccessor.removeGroup(group);
        this.spacePermissionManager.removeAllPermissionsForGroup(group.getName());
        return true;
    }

    public String[] getGroups() throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        Pager pager = this.userAccessor.getGroups();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = pager.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            arrayList.add(group.getName());
        }
        return arrayList.toArray(new String[1]);
    }

    public boolean deactivateUser(String string) throws NotPermittedException, RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        if (this.userAccessor.isDeactivated(user)) {
            throw new RemoteException("User has already been deactivated");
        }
        this.userAccessor.deactivateUser(user);
        return true;
    }

    public boolean reactivateUser(String string) throws NotPermittedException, RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        User user = this.retrieveUser(string);
        if (!this.userAccessor.isDeactivated(user)) {
            throw new RemoteException("User is already active");
        }
        this.userAccessor.reactivateUser(user);
        return true;
    }

    public String[] getActiveUsers(boolean bl) throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        Pager pager = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        pager = bl ? this.userAccessor.getUsers() : this.userAccessor.getUsersWithConfluenceAccess();
        Iterator iterator = pager.iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            arrayList.add(user.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean changeMyPassword(String string, String string2) throws NotPermittedException, RemoteException {
        if (string2 == null || string2.length() == 0) {
            throw new RemoteException("New password cannot be null or empty");
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.userAccessor.authenticate(user.getName(), string)) {
            throw new NotPermittedException("The current password was incorrect. Please try again.");
        }
        try {
            this.userAccessor.alterPassword(user, string2);
        }
        catch (EntityException entityException) {
            throw new RemoteException((Throwable)entityException);
        }
        return true;
    }

    public boolean changeUserPassword(String string, String string2) throws NotPermittedException, RemoteException {
        if (string2 == null || string2.length() == 0) {
            throw new RemoteException("New password cannot be null or empty.");
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        User user2 = this.retrieveUser(string);
        if (!this.canUserAdminister(user)) {
            throw new NotPermittedException("You do not have the correct permissions to perform this action.");
        }
        try {
            this.userAccessor.alterPassword(user2, string2);
        }
        catch (EntityException entityException) {
            throw new RemoteException("Error changing password for user " + string, (Throwable)entityException);
        }
        return true;
    }

    public boolean setUserInformation(RemoteUserInformation remoteUserInformation) throws RemoteException {
        User user;
        User user2 = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user2, Permission.EDIT, (Object)(user = this.retrieveUser(remoteUserInformation.getUsername())))) {
            throw new NotPermittedException("You are not logged in as the correct user, or you do not have the correct permissions to perform this action.");
        }
        if (remoteUserInformation.getContent() != null) {
            PersonalInformation personalInformation = this.personalInformationManager.getPersonalInformation(user.getName());
            PersonalInformation personalInformation2 = null;
            if (personalInformation == null) {
                personalInformation = new PersonalInformation(user, this.userAccessor);
            } else {
                try {
                    personalInformation2 = (PersonalInformation)personalInformation.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new RemoteException("Error saving personal information: Clone not supported");
                }
            }
            if (personalInformation.getId() != remoteUserInformation.getId()) {
                throw new RemoteException("Error saving personal information: ID cannot be changed");
            }
            if (personalInformation.getContent().equals(remoteUserInformation.getContent())) {
                return true;
            }
            personalInformation.setContent(remoteUserInformation.getContent());
            this.personalInformationManager.savePersonalInformation(personalInformation, personalInformation2);
        }
        return true;
    }

    public RemoteUserInformation getUserInformation(String string) throws RemoteException {
        User user = this.retrieveUser(string);
        PersonalInformation personalInformation = this.personalInformationManager.getPersonalInformation(user.getName());
        return personalInformation == null ? null : new RemoteUserInformation(personalInformation);
    }

    public boolean hasUser(String string, String string2) {
        User user = this.userAccessor.getUser(string2);
        return user != null;
    }

    public boolean hasGroup(String string) {
        Group group = this.userAccessor.getGroup(string);
        return group != null;
    }

    public PersonalInformationManager getPersonalInformationManager() {
        return this.personalInformationManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public boolean addProfilePicture(String string, String string2, String string3, byte[] byArray) throws RemoteException {
        if (!string3.toLowerCase().startsWith("image/")) {
            throw new RemoteException("Invalid MIME type. Only image/* types may be used for profile pictures");
        }
        User user = this.userAccessor.getUser(string);
        if (user == null) {
            throw new RemoteException("User does not exist");
        }
        User user2 = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user2, Permission.EDIT, (Object)user)) {
            throw new NotPermittedException("You are not permitted to add a profile picture for the specified user");
        }
        File file = new ProfilePicture((InputStream)new ByteArrayInputStream(byArray), string2).create();
        if (file == null) {
            throw new RemoteException("There was a problem resizing the image");
        }
        PersonalInformation personalInformation = this.personalInformationManager.getPersonalInformation(string);
        Attachment attachment = this.attachmentManager.getAttachment((ContentEntityObject)personalInformation, string2);
        Attachment attachment2 = null;
        if (attachment == null) {
            attachment = new Attachment();
        } else {
            try {
                attachment2 = (Attachment)attachment.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RemoteException("Error adding profile picture: Clone not supported");
            }
        }
        attachment.setContentType(string3);
        attachment.setFileName(string2);
        attachment.setComment("Uploaded Profile Picture");
        attachment.setFileSize((long)byArray.length);
        personalInformation.addAttachment(attachment);
        try {
            this.attachmentManager.saveAttachment(attachment, attachment2, (InputStream)new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RemoteException("Error adding profile picture: Cound not save attachment");
        }
        UserPreferences userPreferences = new UserPreferences(this.userAccessor.getPropertySet(user));
        try {
            userPreferences.setString("confluence.user.profile.picture", string2);
        }
        catch (AtlassianCoreException atlassianCoreException) {
            throw new RemoteException("Problem setting user preferences", (Throwable)atlassianCoreException);
        }
        return true;
    }
}

