/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.importexport.DefaultExportContext;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SpacesSoapService {
    SpaceManager spaceManager;
    PermissionManager permissionManager;
    SpacePermissionManager spacePermissionManager;
    PersonalInformationManager personalInformationManager;
    WikiStyleRenderer wikiStyleRenderer;
    SoapServiceHelper soapServiceHelper;
    ImportExportManager importExportManager;
    BootstrapManager bootstrapManager;
    private GateKeeper gateKeeper;
    UserAccessor userAccessor;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$Comment;
    static /* synthetic */ Class class$com$atlassian$confluence$spaces$Space;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setPersonalInformationManager(PersonalInformationManager personalInformationManager) {
        this.personalInformationManager = personalInformationManager;
    }

    public RemoteSpaceSummary[] getSpaces() throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        List list = this.spaceManager.getPermittedSpaces(user);
        return SoapUtils.getSpaceSummaries(list);
    }

    public RemoteSpace getSpace(String string) throws RemoteException {
        return new RemoteSpace(this.soapServiceHelper.retrieveSpace(string), this.wikiStyleRenderer);
    }

    public String[] getPermissions(String string) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        Space space = this.soapServiceHelper.retrieveSpace(string);
        return this.getUserPermissions(space, user);
    }

    public String[] getPermissions(String string, String string2) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        Space space = this.soapServiceHelper.retrieveSpace(string);
        User user2 = this.userAccessor.getUser(string2);
        if (!(GeneralUtil.isSuperUser((User)user) || this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space) || user.equals(user2))) {
            throw new NotPermittedException("Only space administrators can view permissions for other users in the space.");
        }
        if (string2 == null || this.userAccessor.getUser(string2) == null) {
            throw new RemoteException("No user with the name '" + string2 + "' exists.");
        }
        return this.getUserPermissions(space, user2);
    }

    private String[] getUserPermissions(Space space, User user) {
        boolean bl;
        boolean bl2 = GeneralUtil.isSuperUser((User)user);
        boolean bl3 = bl2 || this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space);
        boolean bl4 = bl = bl2 || this.permissionManager.hasPermission(user, Permission.EDIT, (Object)space);
        boolean bl5 = bl2 || this.permissionManager.hasCreatePermission(user, (Object)space, class$com$atlassian$confluence$pages$Comment == null ? (class$com$atlassian$confluence$pages$Comment = SpacesSoapService.class$("com.atlassian.confluence.pages.Comment")) : class$com$atlassian$confluence$pages$Comment);
        boolean bl6 = bl2 || this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        if (bl3) {
            arrayList.add("view");
        }
        if (bl) {
            arrayList.add("modify");
        }
        if (bl5) {
            arrayList.add("comment");
        }
        if (bl6) {
            arrayList.add("admin");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public RemoteSpace addSpace(RemoteSpace remoteSpace) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.spaceManager.isValidSpaceKey(remoteSpace.getKey())) {
            throw new RemoteException("Invalid space key: " + remoteSpace.getKey());
        }
        if (!this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, class$com$atlassian$confluence$spaces$Space == null ? (class$com$atlassian$confluence$spaces$Space = SpacesSoapService.class$("com.atlassian.confluence.spaces.Space")) : class$com$atlassian$confluence$spaces$Space)) {
            throw new NotPermittedException("No permission to create spaces.");
        }
        if (this.spaceManager.getSpace(remoteSpace.getKey()) != null) {
            throw new AlreadyExistsException("A space already exists with key " + remoteSpace.getKey());
        }
        return new RemoteSpace(this.spaceManager.createSpace(remoteSpace.getKey(), remoteSpace.getName(), remoteSpace.getDescription(), user), this.wikiStyleRenderer);
    }

    protected void verifyPersonalSpaceCreation(User user) throws NotPermittedException, AlreadyExistsException {
        User user2 = AuthenticatedUserThreadLocal.getUser();
        boolean bl = GeneralUtil.isSuperUser((User)user2);
        PersonalInformation personalInformation = this.personalInformationManager.getPersonalInformation(user.getName());
        if (!this.permissionManager.hasCreatePermission(user2, (Object)personalInformation, class$com$atlassian$confluence$spaces$Space == null ? (class$com$atlassian$confluence$spaces$Space = SpacesSoapService.class$("com.atlassian.confluence.spaces.Space")) : class$com$atlassian$confluence$spaces$Space)) {
            throw new NotPermittedException("No permission to create spaces.");
        }
        if (!(user2 == null || user.getName().equals(user2.getName()) || bl || this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION))) {
            throw new NotPermittedException("No permission to create a personal space for user " + user.getName());
        }
        if (this.spaceManager.getSpace("~" + user.getName()) != null) {
            throw new AlreadyExistsException("A space already exists with key ~" + user.getName());
        }
    }

    public RemoteSpace addPersonalSpace(RemoteSpace remoteSpace, String string) throws RemoteException {
        User user = this.userAccessor.getUser(string);
        if (user == null) {
            throw new RemoteException("No user found with name " + string);
        }
        this.verifyPersonalSpaceCreation(user);
        return new RemoteSpace(this.spaceManager.createPersonalSpace(remoteSpace.getName(), remoteSpace.getDescription(), user), this.wikiStyleRenderer);
    }

    public boolean convertToPersonalSpace(String string, String string2, String string3, boolean bl) throws RemoteException {
        User user = this.userAccessor.getUser(string);
        if (user == null) {
            throw new RemoteException("No user found with name " + string);
        }
        this.verifyPersonalSpaceCreation(user);
        Space space = this.spaceManager.getSpace(string2);
        if (space == null) {
            throw new RemoteException("Space '" + string2 + "' does not exist");
        }
        User user2 = AuthenticatedUserThreadLocal.getUser();
        boolean bl2 = GeneralUtil.isSuperUser((User)user2);
        if (!bl2 && !this.permissionManager.hasPermission(user2, Permission.ADMINISTER, (Object)space)) {
            throw new NotPermittedException("You are not permitted to convert the space'" + string2 + "' to a personal space");
        }
        this.spaceManager.convertToPersonalSpace(space, user, bl);
        return true;
    }

    public String[] getSpaceLevelPermissions() throws RemoteException {
        List list = SpacePermission.getGenericSpacePermissions();
        String[] stringArray = new String[list.size() + 1];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        stringArray[stringArray.length - 1] = "VIEWSPACE";
        return stringArray;
    }

    public boolean addPermissionToSpace(String string, String string2, String string3) throws RemoteException {
        if (string == null) {
            throw new RemoteException("Space Permission must be non-null");
        }
        String[] stringArray = new String[]{string};
        return this.addPermissionsToSpace(stringArray, string2, string3);
    }

    private Space validatePermissionsOperation(String string) throws RemoteException {
        Space space = this.spaceManager.getSpace(string);
        if (space == null) {
            throw new NotPermittedException("Not permitted to add space permissions");
        }
        this.soapServiceHelper.assertCanAdminister(space);
        return space;
    }

    public boolean addPermissionsToSpace(String[] stringArray, String string, String string2) throws RemoteException, NotPermittedException {
        if (stringArray == null) {
            throw new RemoteException("Space Permissions must be non-null");
        }
        Space space = this.validatePermissionsOperation(string2);
        UserOrGroupResolver userOrGroupResolver = new UserOrGroupResolver(string);
        List list = space.getPermissions();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            SpacePermission spacePermission = new SpacePermission(string3, space, userOrGroupResolver.getGroupName(), userOrGroupResolver.getUserName());
            if (list.contains(spacePermission)) continue;
            space.addPermission(spacePermission);
            this.spacePermissionManager.savePermission(spacePermission);
        }
        return true;
    }

    public boolean removePermissionFromSpace(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        Space space = this.validatePermissionsOperation(string3);
        UserOrGroupResolver userOrGroupResolver = new UserOrGroupResolver(string2);
        List list = space.getPermissions();
        SpacePermission spacePermission = new SpacePermission(string, space, userOrGroupResolver.getGroupName(), userOrGroupResolver.getUserName());
        for (int i = 0; i < list.size(); ++i) {
            SpacePermission spacePermission2 = (SpacePermission)list.get(i);
            if (!spacePermission.equals((Object)spacePermission2)) continue;
            this.spacePermissionManager.removePermission(spacePermission2);
        }
        return true;
    }

    public Boolean removeSpace(String string) throws RemoteException {
        Space space = this.spaceManager.getSpace(string);
        if (space == null) {
            throw new RemoteException("No space found for space key: " + string);
        }
        this.soapServiceHelper.assertCanView(space);
        this.soapServiceHelper.assertCanAdminister(space);
        this.spaceManager.removeSpace(space);
        return Boolean.TRUE;
    }

    public String exportSpace(String string, String string2) throws RemoteException {
        String string3;
        if (string2.equals("all")) {
            string2 = "TYPE_XML";
        }
        if (!this.importExportManager.getImportExportTypeSpecifications().contains(string2)) {
            throw new RemoteException("Invalid export type: [" + string2 + "]");
        }
        Space space = this.spaceManager.getSpace(string);
        if (space == null) {
            throw new RemoteException("Invalid spaceKey: [" + string + "]");
        }
        this.soapServiceHelper.assertCanExport(space);
        User user = AuthenticatedUserThreadLocal.getUser();
        try {
            DefaultExportContext defaultExportContext = new DefaultExportContext("space");
            defaultExportContext.setExportComments(true);
            defaultExportContext.setExportAttachments(true);
            defaultExportContext.addWorkingEntity((ConfluenceEntityObject)space);
            defaultExportContext.setContentTree(this.importExportManager.getContentTree(user, space));
            String string4 = this.importExportManager.exportAs((Object)string2, (ExportContext)defaultExportContext);
            string3 = this.importExportManager.prepareDownloadPath(string4);
            this.gateKeeper.addKey(string3, user);
        }
        catch (ImportExportException importExportException) {
            return "Could not export space: " + (Object)((Object)importExportException);
        }
        catch (IOException iOException) {
            return "Could not export space: " + iOException;
        }
        return this.bootstrapManager.getBaseUrl() + string3;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UserOrGroupResolver {
        private String userName = null;
        private String groupName = null;

        public UserOrGroupResolver(String string) throws RemoteException {
            if (string != null) {
                User user = SpacesSoapService.this.userAccessor.getUser(string);
                if (user == null) {
                    Group group = SpacesSoapService.this.userAccessor.getGroup(string);
                    if (group == null) {
                        throw new RemoteException("No user or group with the name '" + string + "' exists.");
                    }
                    this.groupName = string;
                } else {
                    this.userName = string;
                }
            }
        }

        public String getUserName() {
            return this.userName;
        }

        public String getGroupName() {
            return this.groupName;
        }
    }
}

