/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.util.Iterator;
import java.util.List;

public class SoapServiceHelperImpl
implements SoapServiceHelper {
    protected SpaceManager spaceManager;
    protected PermissionManager permissionManager;
    protected PageManager pageManager;
    protected LinkManager linkManager;
    protected UserAccessor userAccessor;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$Page;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$BlogPost;

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public Space retrieveSpace(String string) throws RemoteException {
        Space space;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)(space = this.spaceManager.getSpace(string)))) {
            throw new RemoteException("You're not allowed to view that space, or it does not exist.");
        }
        return space;
    }

    public AbstractPage retrieveAbstractPage(long l) throws RemoteException {
        AbstractPage abstractPage = this.pageManager.getAbstractPage(l);
        this.assertCanView(abstractPage);
        return abstractPage;
    }

    public Page retrievePage(String string, String string2) throws RemoteException {
        Page page = this.pageManager.getPage(string, string2);
        this.assertCanView((AbstractPage)page);
        return page;
    }

    public User retrieveUser(String string) throws RemoteException {
        User user = this.userAccessor.getUser(string);
        if (user == null) {
            throw new RemoteException("The user '" + string + "' does not exist.");
        }
        return user;
    }

    public void assertCanView(AbstractPage abstractPage) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (abstractPage != null && GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (abstractPage != null && abstractPage.getOriginalVersion() != null) {
            abstractPage = (AbstractPage)abstractPage.getOriginalVersion();
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)abstractPage)) {
            throw new RemoteException("You're not allowed to view that page, or it does not exist.");
        }
    }

    public void assertCanView(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (space != null && GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)space)) {
            throw new NotPermittedException("Space does not exist, or you do not have permission to view it.");
        }
    }

    public void renamePage(Page page, String string) throws RemoteException {
        List list = this.linkManager.getIncomingLinksToContent((ContentEntityObject)page);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            OutgoingLink outgoingLink = (OutgoingLink)iterator.next();
            try {
                ContentEntityObject contentEntityObject = (ContentEntityObject)outgoingLink.getSourceContent().clone();
                String string2 = this.linkManager.getContentWithRenamedLinks(outgoingLink.getSourceContent(), (SpaceContentEntityObject)page, page.getSpace().getKey(), string);
                outgoingLink.getSourceContent().setContent(string2);
                this.pageManager.saveContentEntity(outgoingLink.getSourceContent(), contentEntityObject, null);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RemoteException("Something went horribly wrong renaming the links to this page", (Throwable)cloneNotSupportedException);
            }
        }
        this.pageManager.renamePage((AbstractPage)page, string);
    }

    public void assertCanModifyObject(Object object, String string) throws NotPermittedException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, object)) {
            throw new NotPermittedException("You do not have permission to edit " + string);
        }
    }

    public void assertCanCreatePage(Space space) throws RemoteException {
        this.assertCanCreate(space, class$com$atlassian$confluence$pages$Page == null ? (class$com$atlassian$confluence$pages$Page = SoapServiceHelperImpl.class$("com.atlassian.confluence.pages.Page")) : class$com$atlassian$confluence$pages$Page, "pages");
    }

    public void assertCanCreateBlogPost(Space space) throws RemoteException {
        this.assertCanCreate(space, class$com$atlassian$confluence$pages$BlogPost == null ? (class$com$atlassian$confluence$pages$BlogPost = SoapServiceHelperImpl.class$("com.atlassian.confluence.pages.BlogPost")) : class$com$atlassian$confluence$pages$BlogPost, "blog posts");
    }

    private void assertCanCreate(Space space, Class clazz, String string) throws RemoteException {
        this.assertCanView(space);
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (!this.permissionManager.hasCreatePermission(user, (Object)space, clazz)) {
            throw new NotPermittedException("You do not have permission to create " + string + " in this space.");
        }
    }

    public void assertCanModify(AbstractPage abstractPage) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (!this.permissionManager.hasPermission(user, Permission.EDIT, (Object)abstractPage)) {
            throw new NotPermittedException("You do not have permission to edit this page");
        }
    }

    public void assertCanRemove(AbstractPage abstractPage) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (GeneralUtil.isSuperUser((User)user)) {
            return;
        }
        if (!this.permissionManager.hasPermission(user, Permission.REMOVE, (Object)abstractPage)) {
            throw new NotPermittedException("You do not have permission to remove this page");
        }
    }

    public void assertCanAdministrate() throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION)) {
            throw new NotPermittedException("You don't have administration permission.");
        }
    }

    public void assertCanExport(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.hasPermission(user, Permission.EXPORT, space)) {
            throw new NotPermittedException("You don't have permission to export the space: " + space.getKey());
        }
    }

    public void assertCanAdminister(Space space) throws RemoteException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.hasPermission(user, Permission.ADMINISTER, space)) {
            throw new NotPermittedException("You don't have permission to administer the space: " + space.getKey());
        }
    }

    private boolean hasPermission(User user, Permission permission, Space space) {
        return GeneralUtil.isSuperUser((User)user) || this.permissionManager.hasPermission(user, permission, (Object)space);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

