/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import bucket.core.InfrastructureException;
import bucket.core.actions.PaginationSupport;
import bucket.core.persistence.AnyTypeObjectDao;
import bucket.search.Searcher;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermission;
import com.atlassian.confluence.core.actions.StylesheetAction;
import com.atlassian.confluence.event.EventManager;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.search.SearchPerformedEvent;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.VersionMismatchException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.actions.SearchBean;
import com.atlassian.confluence.search.actions.SearchQueryBean;
import com.atlassian.confluence.search.actions.SearchResultWithExcerpt;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PagesSoapService {
    EventManager eventManager;
    PageManager pageManager;
    SpaceManager spaceManager;
    ContentEntityManager contentEntityManager;
    PermissionManager permissionManager;
    CommentManager commentManager;
    WikiStyleRenderer wikiStyleRenderer;
    BootstrapManager bootstrapManager;
    AnyTypeObjectDao anyTypeObjectDao;
    Searcher searcher;
    SoapServiceHelper soapServiceHelper;
    private UserAccessor userAccessor;
    private LabelManager labelManager;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$Comment;

    public RemotePageSummary[] getPages(String string) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(string);
        return SoapUtils.getPageSummaries(this.getPermittedEntities(this.spaceManager.getPages(space, true)));
    }

    public RemotePage getPage(long l) throws RemoteException {
        return new RemotePage((Page)this.soapServiceHelper.retrieveAbstractPage(l));
    }

    public RemotePage getPage(String string, String string2) throws RemoteException {
        return new RemotePage(this.soapServiceHelper.retrievePage(string, string2));
    }

    public RemoteComment[] getComments(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        return SoapUtils.getComments(abstractPage.getComments());
    }

    public RemoteComment getComment(long l) throws RemoteException {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        if (contentEntityObject == null || !this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)contentEntityObject)) {
            throw new RemoteException("You do not have permission to view the comment, or it does not exist.");
        }
        if (!(contentEntityObject instanceof Comment)) {
            throw new RemoteException("Object for given comment ID is not a comment.");
        }
        Comment comment = (Comment)contentEntityObject;
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)comment.getPage())) {
            throw new RemoteException("You do not have permission to view the comment, or it does not exist.");
        }
        return new RemoteComment(comment);
    }

    public RemoteComment addComment(RemoteComment remoteComment) throws NotPermittedException, RemoteException {
        long l = remoteComment.getPageId();
        AbstractPage abstractPage = this.pageManager.getAbstractPage(l);
        if (abstractPage == null) {
            throw new RemoteException("Can not add comment to non-existant page with id: " + l);
        }
        this.soapServiceHelper.assertCanView(abstractPage);
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), (Object)abstractPage, class$com$atlassian$confluence$pages$Comment == null ? (class$com$atlassian$confluence$pages$Comment = PagesSoapService.class$("com.atlassian.confluence.pages.Comment")) : class$com$atlassian$confluence$pages$Comment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        if (remoteComment.getContent() == null || remoteComment.getContent().length() == 0) {
            throw new RemoteException("Comment text must be non-null");
        }
        Comment comment = null;
        if (remoteComment.getParentId() != 0L && (comment = this.commentManager.getComment(remoteComment.getParentId())) == null) {
            throw new RemoteException("That parent comment does not exist.");
        }
        Comment comment2 = this.commentManager.addCommentToPage(abstractPage, comment, remoteComment.getContent());
        return new RemoteComment(comment2);
    }

    public boolean removeComment(long l) throws NotPermittedException, RemoteException {
        Comment comment = this.commentManager.getComment(l);
        if (comment == null) {
            throw new RemoteException("That comment does not exist.");
        }
        AbstractPage abstractPage = comment.getPage();
        this.soapServiceHelper.assertCanView(abstractPage);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)comment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        this.commentManager.removeCommentFromPage(l);
        return true;
    }

    public RemotePageSummary[] getDescendents(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        if (abstractPage instanceof Page) {
            Page page = (Page)abstractPage;
            List list = this.getPermittedEntities(this.pageManager.getDescendents(page));
            Collections.sort(list);
            return SoapUtils.getPageSummaries(list);
        }
        throw new RemoteException(l + " is not a page?");
    }

    public RemotePageSummary[] getAncestors(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        if (abstractPage instanceof Page) {
            Page page = (Page)abstractPage;
            return SoapUtils.getPageSummaries(this.getPermittedEntities(page.getAncestors()));
        }
        throw new RemoteException(l + " is not a page?");
    }

    public RemotePageSummary[] getChildren(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        if (abstractPage instanceof Page) {
            Page page = (Page)abstractPage;
            return SoapUtils.getPageSummaries(this.getPermittedEntities(page.getChildren()));
        }
        throw new RemoteException(l + " is not a page?");
    }

    public RemoteAttachment[] getAttachments(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        return SoapUtils.getAttachments(abstractPage.getLatestVersionsOfAttachments());
    }

    public RemotePageHistory[] getPageHistory(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        if (abstractPage.getOriginalVersion() != null) {
            throw new VersionMismatchException("This is not the most recent version of this page");
        }
        return SoapUtils.getPageHistory(abstractPage);
    }

    public Boolean removePage(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        this.soapServiceHelper.assertCanRemove(abstractPage);
        if (abstractPage.getOriginalVersion() != null) {
            throw new RemoteException("You can't remove an old version of the page - remove the current version.");
        }
        if (abstractPage.isDeleted()) {
            return Boolean.TRUE;
        }
        this.pageManager.trashPage(abstractPage);
        return Boolean.TRUE;
    }

    public RemoteSearchResult[] search(String string, Map map, int n) throws RemoteException {
        try {
            SearchQueryBean searchQueryBean = new SearchQueryBean(this.searcher, this.spaceManager, this.userAccessor, this.labelManager);
            searchQueryBean.setQueryString(string);
            if (map.containsKey("spaceKey")) {
                searchQueryBean.setSpaceKey((String)map.get("spaceKey"));
            }
            if (map.containsKey("type")) {
                searchQueryBean.setType((String)map.get("type"));
            }
            if (map.containsKey("modified")) {
                searchQueryBean.setLastModified((String)map.get("modified"));
            }
            SearchBean searchBean = new SearchBean();
            searchBean.setPaginationSupport(new PaginationSupport(n));
            searchBean.setAnyTypeObjectDao(this.anyTypeObjectDao);
            searchBean.setSearcher(this.searcher);
            List list = searchBean.search(searchQueryBean.buildQuery());
            int n2 = Math.min(n, list.size());
            ArrayList<RemoteSearchResult> arrayList = new ArrayList<RemoteSearchResult>(n2);
            for (int i = 0; i < n2; ++i) {
                SearchResultWithExcerpt searchResultWithExcerpt = (SearchResultWithExcerpt)list.get(i);
                Addressable addressable = (Addressable)searchResultWithExcerpt.getResultObject();
                if (addressable == null) continue;
                arrayList.add(new RemoteSearchResult(addressable));
            }
            SearchQueryBean searchQueryBean2 = new SearchQueryBean(searchQueryBean);
            searchQueryBean2.unwire();
            this.eventManager.publishEvent((ConfluenceEvent)new SearchPerformedEvent((Object)this, searchQueryBean2, AuthenticatedUserThreadLocal.getUser(), arrayList.size()));
            return arrayList.toArray(new RemoteSearchResult[arrayList.size()]);
        }
        catch (IOException iOException) {
            throw new RemoteException((Throwable)iOException);
        }
    }

    public RemoteSearchResult[] search(String string, int n) throws RemoteException {
        return this.search(string, Collections.EMPTY_MAP, n);
    }

    public String renderContent(String string, long l, String string2) throws RemoteException {
        return this.renderContent(string, l, string2, null);
    }

    public String renderContent(String string, long l, String string2, Map map) throws RemoteException {
        PageContext pageContext;
        AbstractPage abstractPage = null;
        if (l > 0L) {
            abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
            pageContext = abstractPage.toPageContext();
        } else {
            if (!TextUtils.stringSet((String)string)) {
                throw new RemoteException("You must specify a space key to render non existant content.");
            }
            pageContext = new PageContext(string);
        }
        String string3 = string2;
        if (!TextUtils.stringSet((String)string3)) {
            string3 = abstractPage.getContent();
        }
        String string4 = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, string3);
        if (map != null && map.containsKey("style") && "clean".equalsIgnoreCase((String)map.get("style"))) {
            return "<div id=\"ConfluenceContent\">" + string4 + "</div>";
        }
        String string5 = "<html><head>\n";
        string5 = string5 + "<title>" + (abstractPage != null ? abstractPage.getTitle() : "Untitled") + "</title>\n";
        string5 = string5 + "<style>\n" + StylesheetAction.renderSpaceStylesheet((Space)(abstractPage != null ? abstractPage.getSpace() : null)) + "</style>\n";
        string5 = string5 + "<base href=\"" + this.bootstrapManager.getBaseUrl() + "\"/>\n";
        string5 = string5 + "</head>\n<body>\n<div id=\"Content\" style=\"padding: 5px;\">\n";
        string5 = string5 + string4;
        string5 = string5 + "\n</div>\n</body></html>";
        return string5;
    }

    public RemotePage storePage(RemotePage remotePage) throws RemoteException {
        if (remotePage.getId() <= 0L) {
            return this.createPage(remotePage);
        }
        return this.updatePage(remotePage);
    }

    private RemotePage createPage(RemotePage remotePage) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(remotePage.getSpace());
        this.soapServiceHelper.assertCanView(space);
        Page page = this.pageManager.getPage(remotePage.getSpace(), remotePage.getTitle());
        this.soapServiceHelper.assertCanCreatePage(space);
        if (page != null) {
            throw new RemoteException("The page you are trying to create already exists.");
        }
        page = new Page();
        page.setSpace(space);
        page.setTitle(remotePage.getTitle());
        page.setContent(remotePage.getContent());
        if (remotePage.getParentId() > 0L) {
            Page page2 = this.pageManager.getPage(remotePage.getParentId());
            if (page2 == null) {
                throw new RemoteException("The parent ID specified does not exist?");
            }
            page2.addChild(page);
        }
        this.pageManager.saveContentEntity((ContentEntityObject)page, null);
        return new RemotePage(page);
    }

    private RemotePage updatePage(RemotePage remotePage) throws RemoteException {
        Page page;
        Page page2 = (Page)this.soapServiceHelper.retrieveAbstractPage(remotePage.getId());
        this.soapServiceHelper.assertCanModify((AbstractPage)page2);
        if (!page2.getSpace().getKey().equals(remotePage.getSpace())) {
            throw new RemoteException("You can't change an existing page's space.");
        }
        if (page2.getVersion() != remotePage.getVersion()) {
            throw new VersionMismatchException("You're trying to edit an outdated version of that page.");
        }
        try {
            page = (Page)page2.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InfrastructureException("Uh oh, couldn't clone a page?!");
        }
        boolean bl = false;
        if (!page2.getTitle().equals(remotePage.getTitle())) {
            this.soapServiceHelper.renamePage(page2, remotePage.getTitle());
        }
        if (!remotePage.getContent().equals(page2.getContent())) {
            page2.setContent(remotePage.getContent());
            bl = true;
        }
        Page page3 = this.pageManager.getPage(remotePage.getParentId());
        Page page4 = page2.getParent();
        if (page3 == null) {
            if (page4 != null) {
                page4.removeChild(page2);
                page2.setParentPage(null);
                bl = true;
            }
        } else if (page4 == null) {
            page3.addChild(page2);
            bl = true;
        } else if (page4.getId() != page3.getId()) {
            page4.removeChild(page2);
            page3.addChild(page2);
            bl = true;
        }
        if (bl) {
            this.pageManager.saveContentEntity((ContentEntityObject)page2, (ContentEntityObject)page, null);
        }
        return new RemotePage(page2);
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public RemotePermission[] getPermissions(long l) throws RemoteException {
        AbstractPage abstractPage = this.soapServiceHelper.retrieveAbstractPage(l);
        ArrayList<RemotePermission> arrayList = new ArrayList<RemotePermission>(abstractPage.getPermissions().size());
        Iterator iterator = abstractPage.getPermissions().iterator();
        while (iterator.hasNext()) {
            ContentPermission contentPermission = (ContentPermission)iterator.next();
            arrayList.add(new RemotePermission(contentPermission));
        }
        return arrayList.toArray(new RemotePermission[arrayList.size()]);
    }

    private List getPermittedEntities(List list) {
        return this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, list);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setAnyTypeObjectDao(AnyTypeObjectDao anyTypeObjectDao) {
        this.anyTypeObjectDao = anyTypeObjectDao;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

