/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.LabelPermissionSupport;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;
import com.atlassian.confluence.renderer.WikiStyleRenderer;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LabelsSoapService {
    LabelManager labelManager;
    ContentEntityManager contentEntityManager;
    SpacePermissionManager spacePermissionManager;
    SpaceManager spaceManager;
    PermissionManager permissionManager;
    WikiStyleRenderer wikiStyleRenderer;
    SoapServiceHelper soapServiceHelper;

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    private RemoteLabel[] generateRemoteLabelArray(List list) {
        if (list == null) {
            return null;
        }
        RemoteLabel[] remoteLabelArray = new RemoteLabel[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RemoteLabel remoteLabel;
            Label label = this.getLabelFromUnknownLabelLikeObject(list.get(i));
            remoteLabelArray[i] = remoteLabel = new RemoteLabel(label);
        }
        return remoteLabelArray;
    }

    private RemoteLabel[] generateRemoteLabelCountArray(List list) {
        if (list == null) {
            return null;
        }
        RemoteLabel[] remoteLabelArray = new RemoteLabel[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RemoteLabel remoteLabel;
            Label label = this.getLabelFromUnknownLabelLikeObject(list.get(i));
            remoteLabelArray[i] = remoteLabel = new RemoteLabel(label);
        }
        return remoteLabelArray;
    }

    private Label getLabelFromUnknownLabelLikeObject(Object object) {
        if (object instanceof LabelSearchResult) {
            object = ((LabelSearchResult)object).getLabel();
        }
        return (Label)object;
    }

    public RemoteLabel[] getLabelsById(long l) throws RemoteException {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        this.assertObjectExists(l, contentEntityObject);
        this.assertUserCanViewObject((Labelable)contentEntityObject);
        List list = contentEntityObject.getLabels();
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteLabel[] getMostPopularLabels(int n) throws RemoteException {
        List list = this.labelManager.getMostPopularLabels(n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String string, int n) throws RemoteException {
        this.soapServiceHelper.retrieveSpace(string);
        List list = this.labelManager.getMostPopularLabelsInSpace(string, n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelCountArray(list2);
    }

    private RemoteSearchResult[] getFilteredContentForLabelObject(Label label) throws RemoteException {
        if (label == null) {
            throw new RemoteException("The given label ID or name was not valid");
        }
        List list = this.labelManager.getCurrentContentForLabel(label);
        ArrayList<RemoteSearchResult> arrayList = new ArrayList<RemoteSearchResult>();
        for (int i = 0; i < list.size(); ++i) {
            ContentEntityObject contentEntityObject = (ContentEntityObject)list.get(i);
            if (!LabelPermissionSupport.userCanViewObject((Labelable)contentEntityObject, (PermissionManager)this.permissionManager)) continue;
            RemoteSearchResult remoteSearchResult = new RemoteSearchResult((Addressable)contentEntityObject);
            arrayList.add(remoteSearchResult);
        }
        return arrayList.toArray(new RemoteSearchResult[arrayList.size()]);
    }

    public RemoteSearchResult[] getLabelContentById(long l) throws RemoteException {
        Label label = this.labelManager.getLabel(l);
        return this.getFilteredContentForLabelObject(label);
    }

    public RemoteSearchResult[] getLabelContentByName(String string) throws RemoteException {
        Label label = this.validateAndGetLabel(string);
        return this.getFilteredContentForLabelObject(label);
    }

    public RemoteSearchResult[] getLabelContentByObject(RemoteLabel remoteLabel) throws RemoteException {
        if (remoteLabel == null) {
            throw new RemoteException("The RemoteLabel object must be non-null");
        }
        return this.getLabelContentById(remoteLabel.getId());
    }

    public RemoteLabel[] getRecentlyUsedLabels(int n) {
        List list = this.labelManager.getRecentlyUsedLabels(n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String string, int n) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(string);
        List list = this.labelManager.getRecentlyUsedLabelsInSpace(string, n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteSpace[] getSpacesWithLabel(String string) throws RemoteException {
        Label label = this.validateAndGetLabel(string);
        List list = this.labelManager.getSpacesWithLabel(label);
        List list2 = this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, list);
        RemoteSpace[] remoteSpaceArray = new RemoteSpace[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (!(e instanceof Space)) {
                throw new RemoteException("Expected Space object in list, but was " + e.getClass());
            }
            remoteSpaceArray[i] = new RemoteSpace((Space)e, (com.atlassian.renderer.WikiStyleRenderer)this.wikiStyleRenderer);
        }
        return remoteSpaceArray;
    }

    public RemoteLabel[] getRelatedLabels(String string, int n) throws RemoteException {
        Label label = this.validateAndGetLabel(string);
        List list = this.labelManager.getRelatedLabels(label, n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String string, String string2, int n) throws RemoteException {
        Label label = this.validateAndGetLabel(string);
        Space space = this.soapServiceHelper.retrieveSpace(string2);
        List list = this.labelManager.getRelatedLabelsInSpace(label, string2, n);
        List list2 = LabelPermissionSupport.filterVisibleLabels((List)list, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list2);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String string) throws RemoteException {
        Label label = this.validateAndGetLabel(string);
        List list = this.labelManager.getSpacesContainingContentWithLabel(label);
        List list2 = this.permissionManager.getPermittedEntities(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, list);
        RemoteSpace[] remoteSpaceArray = new RemoteSpace[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            Object e = list2.get(i);
            if (!(e instanceof Space)) {
                throw new RemoteException("Expected Space object in list, but was " + e.getClass());
            }
            remoteSpaceArray[i] = new RemoteSpace((Space)e, (com.atlassian.renderer.WikiStyleRenderer)this.wikiStyleRenderer);
        }
        return remoteSpaceArray;
    }

    public RemoteLabel[] getLabelsByDetail(String string, String string2, String string3, String string4) throws RemoteException {
        Object object;
        if (TextUtils.stringSet((String)string)) {
            if (!TextUtils.stringSet((String)string)) {
                throw new RemoteException("Label name must be non-null");
            }
            object = LabelParser.parse((String)string);
            if (object == null) {
                throw new RemoteException("The label name '" + string + "' is not valid.");
            }
        }
        if (TextUtils.stringSet((String)string3)) {
            this.soapServiceHelper.retrieveSpace(string3);
        }
        if (TextUtils.stringSet((String)string4)) {
            this.soapServiceHelper.retrieveUser(string4);
        }
        object = this.labelManager.getLabelsByDetail(string, string2, string3, string4);
        List list = LabelPermissionSupport.filterVisibleLabels((List)object, (User)AuthenticatedUserThreadLocal.getUser(), (boolean)true);
        return this.generateRemoteLabelArray(list);
    }

    private boolean addLabelByLabelObject(Label label, long l) throws NotPermittedException, RemoteException {
        if (label == null) {
            throw new RemoteException("The given label ID or name was not valid");
        }
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        this.assertObjectExists(l, contentEntityObject);
        this.assertUserCanEditLabels(label, (Labelable)contentEntityObject);
        this.labelManager.addLabel(contentEntityObject, label);
        return true;
    }

    public boolean addLabelByName(String string, long l) throws NotPermittedException, RemoteException {
        String string2;
        if (!TextUtils.stringSet((String)string)) {
            throw new RemoteException("Label name must be non-null");
        }
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        this.assertObjectExists(l, contentEntityObject);
        List list = LabelUtil.split((String)string);
        ArrayList<ParsedLabelName> arrayList = new ArrayList<ParsedLabelName>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if (!LabelUtil.isValidLabelName((String)string2)) {
                throw new RemoteException("Label name is invalid: " + string2);
            }
            ParsedLabelName parsedLabelName = LabelParser.parse((String)string2);
            if (parsedLabelName == null) continue;
            this.assertUserCanEditLabels(parsedLabelName.toLabel(), (Labelable)contentEntityObject);
            arrayList.add(parsedLabelName);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string2 = (ParsedLabelName)iterator.next();
            string2.addLabel((Labelable)contentEntityObject, this.labelManager);
        }
        return true;
    }

    public boolean addLabelById(long l, long l2) throws NotPermittedException, RemoteException {
        Label label = this.labelManager.getLabel(l);
        return this.addLabelByLabelObject(label, l2);
    }

    public boolean addLabelByObject(RemoteLabel remoteLabel, long l) throws NotPermittedException, RemoteException {
        if (remoteLabel == null) {
            throw new RemoteException("RemoteLabel object must be non-null");
        }
        return this.addLabelById(remoteLabel.getId(), l);
    }

    public boolean addLabelByNameToSpace(String string, String string2) throws RemoteException {
        String string3;
        if (!TextUtils.stringSet((String)string)) {
            throw new RemoteException("Label name must be non-null");
        }
        Space space = this.soapServiceHelper.retrieveSpace(string2);
        SpaceDescription spaceDescription = space.getDescription();
        List list = LabelUtil.split((String)string);
        ArrayList<ParsedLabelName> arrayList = new ArrayList<ParsedLabelName>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            ParsedLabelName parsedLabelName = LabelParser.parse((String)string3);
            if (parsedLabelName == null) {
                throw new RemoteException("Label name is invalid: " + string3);
            }
            if (!LabelPermissionSupport.userCanEditLabel((ParsedLabelName)parsedLabelName, (Labelable)spaceDescription, (PermissionManager)this.permissionManager)) {
                throw new NotPermittedException("You do not have the permission to add the label");
            }
            arrayList.add(parsedLabelName);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string3 = (ParsedLabelName)iterator.next();
            string3.addLabel((Labelable)spaceDescription, this.labelManager);
        }
        return true;
    }

    public boolean removeLabelByName(String string, long l) throws NotPermittedException, RemoteException {
        if (!TextUtils.stringSet((String)string)) {
            throw new RemoteException("Label name must be non-null");
        }
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        this.assertObjectExists(l, contentEntityObject);
        List list = LabelUtil.split((String)string);
        ArrayList<Label> arrayList = new ArrayList<Label>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Label label = this.labelManager.getLabel(LabelParser.parse((String)string2));
            if (label == null) {
                throw new RemoteException("The given label does not exist: " + string2);
            }
            this.assertUserCanRemoveLabel(label, (Labelable)contentEntityObject);
            arrayList.add(label);
        }
        this.labelManager.removeLabels(contentEntityObject, arrayList);
        return true;
    }

    public boolean removeLabelById(long l, long l2) throws NotPermittedException, RemoteException {
        Label label = this.labelManager.getLabel(l);
        if (label == null) {
            throw new RemoteException("The given label ID or name was not valid");
        }
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l2);
        this.assertObjectExists(l2, contentEntityObject);
        this.assertUserCanRemoveLabel(label, (Labelable)contentEntityObject);
        this.labelManager.removeLabel(contentEntityObject, label);
        return true;
    }

    public boolean removeLabelByObject(RemoteLabel remoteLabel, long l) throws NotPermittedException, RemoteException {
        if (remoteLabel == null) {
            throw new RemoteException("RemoteLabel object must be non-null");
        }
        return this.removeLabelById(remoteLabel.getId(), l);
    }

    public boolean removeLabelByNameFromSpace(String string, String string2) throws RemoteException {
        if (!TextUtils.stringSet((String)string)) {
            throw new RemoteException("Label name must be non-null");
        }
        Space space = this.soapServiceHelper.retrieveSpace(string2);
        this.soapServiceHelper.assertCanModifyObject(space, "spaces");
        SpaceDescription spaceDescription = space.getDescription();
        List list = LabelUtil.split((String)string);
        ArrayList<Label> arrayList = new ArrayList<Label>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Label label = this.labelManager.getLabel(LabelParser.parse((String)string3));
            if (label == null) {
                throw new RemoteException("The given label does not exist: " + string3);
            }
            this.assertUserCanRemoveLabel(label, (Labelable)spaceDescription);
            arrayList.add(label);
        }
        this.labelManager.removeLabels((ContentEntityObject)spaceDescription, arrayList);
        return true;
    }

    private void assertUserCanViewObject(Labelable labelable) throws RemoteException {
        if (!LabelPermissionSupport.userCanViewObject((Labelable)labelable, (PermissionManager)this.permissionManager)) {
            throw new RemoteException("You're not allowed to view that ContentEntityObject, or it does not exist.");
        }
    }

    private void assertUserCanEditLabels(Label label, Labelable labelable) throws NotPermittedException, RemoteException {
        if (!LabelPermissionSupport.userCanEditLabel((Label)label, (Labelable)labelable, (PermissionManager)this.permissionManager)) {
            throw new NotPermittedException("You do not have permissions to add labels to this object.");
        }
    }

    private void assertUserCanRemoveLabel(Label label, Labelable labelable) throws NotPermittedException {
        if (!LabelPermissionSupport.userCanEditLabel((Label)label, (Labelable)labelable, (PermissionManager)this.permissionManager)) {
            throw new NotPermittedException("You do not have permission to remove the label '" + label.getName() + "'");
        }
    }

    private void assertObjectExists(long l, ContentEntityObject contentEntityObject) throws RemoteException {
        if (contentEntityObject == null) {
            throw new RemoteException("The object with content id '" + l + "' does not exist.");
        }
    }

    private Label validateAndGetLabel(String string) throws RemoteException {
        if (!TextUtils.stringSet((String)string)) {
            throw new RemoteException("Label name must be non-null");
        }
        ParsedLabelName parsedLabelName = LabelParser.parse((String)string);
        if (parsedLabelName == null) {
            throw new RemoteException("The label name '" + string + "' is not valid.");
        }
        Label label = this.labelManager.getLabel(parsedLabelName);
        if (label == null) {
            throw new RemoteException("The label '" + string + "' does not exist.");
        }
        return label;
    }
}

