/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.SoapUtils;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class BlogsSoapService {
    PageManager pageManager;
    SoapServiceHelper soapServiceHelper;
    private SpaceManager spaceManager;

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String string, int n, String string2) throws RemoteException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(5, n);
        BlogPost blogPost = this.pageManager.getBlogPost(string, string2, (Calendar)gregorianCalendar);
        this.soapServiceHelper.assertCanView((AbstractPage)blogPost);
        return new RemoteBlogEntry(blogPost);
    }

    public RemoteBlogEntry getBlogEntry(long l) throws RemoteException {
        BlogPost blogPost = (BlogPost)this.pageManager.getAbstractPage(l);
        this.soapServiceHelper.assertCanView((AbstractPage)blogPost);
        return new RemoteBlogEntry((BlogPost)this.pageManager.getAbstractPage(l));
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String string) throws RemoteException {
        Space space = this.soapServiceHelper.retrieveSpace(string);
        return SoapUtils.getBlogEntrySummaries(this.spaceManager.getBlogPosts(space, true));
    }

    public RemoteBlogEntry storeBlogEntry(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        if (remoteBlogEntry.getId() <= 0L) {
            return this.createBlog(remoteBlogEntry);
        }
        return this.updateBlog(remoteBlogEntry);
    }

    private RemoteBlogEntry createBlog(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        BlogPost blogPost;
        Space space = this.soapServiceHelper.retrieveSpace(remoteBlogEntry.getSpace());
        this.soapServiceHelper.assertCanView(space);
        this.soapServiceHelper.assertCanCreateBlogPost(space);
        Calendar calendar = Calendar.getInstance();
        if (remoteBlogEntry.getPublishDate() != null) {
            calendar.setTime(remoteBlogEntry.getPublishDate());
        }
        if ((blogPost = this.pageManager.getBlogPost(space.getKey(), remoteBlogEntry.getTitle(), calendar)) != null) {
            throw new RemoteException("A blog post with title '" + remoteBlogEntry.getTitle() + "' already exists for date: " + calendar);
        }
        blogPost = new BlogPost();
        blogPost.setSpace(space);
        blogPost.setTitle(remoteBlogEntry.getTitle());
        blogPost.setContent(remoteBlogEntry.getContent());
        blogPost.setCreationDate(remoteBlogEntry.getPublishDate());
        this.pageManager.saveContentEntity((ContentEntityObject)blogPost, null);
        return new RemoteBlogEntry(blogPost);
    }

    private RemoteBlogEntry updateBlog(RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        BlogPost blogPost = this.pageManager.getBlogPost(remoteBlogEntry.getId());
        this.soapServiceHelper.assertCanModify((AbstractPage)blogPost);
        if (blogPost == null) {
            throw new RemoteException("The blog post with id " + remoteBlogEntry.getId() + " you are trying to update does not exist.)");
        }
        if (!blogPost.getSpace().getKey().equals(remoteBlogEntry.getSpace())) {
            throw new RemoteException("You can't change an existing page's space.");
        }
        if (remoteBlogEntry.getTitle() != null && !blogPost.getTitle().equals(remoteBlogEntry.getTitle())) {
            throw new RemoteException("You currently can't rename a blog post");
        }
        blogPost.setContent(remoteBlogEntry.getContent());
        this.pageManager.saveContentEntity((ContentEntityObject)blogPost, null);
        return new RemoteBlogEntry(blogPost);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }
}

