/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AttachmentsSoapService {
    private AttachmentManager attachmentManager;
    private ContentEntityManager contentEntityManager;
    private PermissionManager permissionManager;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$Attachment;

    public RemoteAttachment addAttachment(RemoteAttachment remoteAttachment, byte[] byArray) throws NotPermittedException, RemoteException {
        return this.addAttachment(remoteAttachment.getPageId(), remoteAttachment, byArray);
    }

    public RemoteAttachment addAttachment(long l, RemoteAttachment remoteAttachment, byte[] byArray) throws NotPermittedException, RemoteException {
        Attachment attachment;
        ContentEntityObject contentEntityObject = this.getCEO(l);
        if (!this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), (Object)contentEntityObject, class$com$atlassian$confluence$pages$Attachment == null ? (class$com$atlassian$confluence$pages$Attachment = AttachmentsSoapService.class$("com.atlassian.confluence.pages.Attachment")) : class$com$atlassian$confluence$pages$Attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        Attachment attachment2 = this.attachmentManager.getAttachment(contentEntityObject, remoteAttachment.getFileName());
        if (attachment2 != null) {
            try {
                attachment = attachment2;
                attachment2 = (Attachment)attachment2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RemoteException((Throwable)cloneNotSupportedException);
            }
        } else {
            attachment = new Attachment();
            contentEntityObject.addAttachment(attachment);
        }
        attachment.setComment(remoteAttachment.getComment());
        attachment.setContentType(remoteAttachment.getContentType());
        attachment.setContent(contentEntityObject);
        attachment.setFileName(remoteAttachment.getFileName());
        attachment.setFileSize((long)byArray.length);
        try {
            this.attachmentManager.saveAttachment(attachment, attachment2, (InputStream)new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RemoteException("Error saving attachment", (Throwable)iOException);
        }
        Attachment attachment3 = this.attachmentManager.getAttachment(contentEntityObject, attachment.getFileName());
        return new RemoteAttachment(attachment3);
    }

    public RemoteAttachment getAttachment(long l, String string, int n) throws NotPermittedException, RemoteException {
        ContentEntityObject contentEntityObject = this.getCEO(l);
        Attachment attachment = this.getExistingAttachment(contentEntityObject, string, n);
        if (attachment == null) {
            // empty if block
        }
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        return new RemoteAttachment(attachment);
    }

    public byte[] getAttachmentData(long l, String string, int n) throws NotPermittedException, RemoteException {
        ContentEntityObject contentEntityObject = this.getCEO(l);
        Attachment attachment = this.getExistingAttachment(contentEntityObject, string, n);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.VIEW, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)attachment.getFileSize());
        try {
            FileUtils.copy((InputStream)this.attachmentManager.getAttachmentData(attachment), (OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RemoteException("Error reading attachment contents", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean removeAttachment(long l, String string) throws NotPermittedException, RemoteException {
        ContentEntityObject contentEntityObject = this.getCEO(l);
        Attachment attachment = this.getExistingCurrentAttachment(contentEntityObject, string);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        this.attachmentManager.removeAttachmentFromServer(attachment);
        return true;
    }

    public boolean moveAttachment(long l, String string, long l2, String string2) throws RemoteException, NotPermittedException {
        ContentEntityObject contentEntityObject = this.getCEO(l);
        Attachment attachment = this.getExistingCurrentAttachment(contentEntityObject, string);
        ContentEntityObject contentEntityObject2 = this.getCEO(l2);
        if (!this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.REMOVE, (Object)attachment) || !this.permissionManager.hasCreatePermission(AuthenticatedUserThreadLocal.getUser(), (Object)contentEntityObject2, class$com$atlassian$confluence$pages$Attachment == null ? (class$com$atlassian$confluence$pages$Attachment = AttachmentsSoapService.class$("com.atlassian.confluence.pages.Attachment")) : class$com$atlassian$confluence$pages$Attachment)) {
            throw new NotPermittedException("You do not have the permissions to perform this action");
        }
        this.attachmentManager.moveAttachment(attachment, string2, contentEntityObject2);
        return true;
    }

    private ContentEntityObject getCEO(long l) throws RemoteException {
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(l);
        if (contentEntityObject == null) {
            throw new RemoteException("No content with id " + l + " exists.");
        }
        return contentEntityObject;
    }

    private Attachment getExistingAttachment(ContentEntityObject contentEntityObject, String string, int n) throws RemoteException {
        Attachment attachment = this.attachmentManager.getAttachment(contentEntityObject, string, n);
        if (attachment == null) {
            throw new RemoteException("No attachment on content with id " + contentEntityObject.getId() + ", name '" + string + "' and version " + n + " exists.");
        }
        return attachment;
    }

    private Attachment getExistingCurrentAttachment(ContentEntityObject contentEntityObject, String string) throws RemoteException {
        Attachment attachment = this.attachmentManager.getAttachment(contentEntityObject, string);
        if (attachment == null) {
            throw new RemoteException("No attachment on content with id " + contentEntityObject.getId() + ", name '" + string + "' exists.");
        }
        return attachment;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

