/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.services;

import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.services.SoapServiceHelper;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.io.IOException;

public class AdminSoapService {
    private ConfluenceIndexManager indexManager;
    private ImportExportManager importExportManager;
    private BootstrapManager bootstrapManager;
    private GateKeeper gateKeeper;
    SoapServiceHelper soapServiceHelper;

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public boolean isConfluenceAdministrator(User user) throws RemoteException {
        return GeneralUtil.isSuperUser((User)user);
    }

    public String exportSite(boolean bl) throws RemoteException {
        Object object;
        String string = null;
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.isConfluenceAdministrator(user)) {
            throw new RemoteException("Authenticated user [" + user + "] is not a Confluence Administrator.");
        }
        try {
            object = this.importExportManager.buildExportContext(bl, false, false, "all");
            String string2 = this.importExportManager.exportAs((Object)"TYPE_ALL_DATA", object);
            string = this.importExportManager.prepareDownloadPath(string2);
            this.gateKeeper.addKey(string, user);
        }
        catch (ImportExportException importExportException) {
            return "Could not export space: " + (Object)((Object)importExportException);
        }
        catch (IOException iOException) {
            return "Could not export space: " + iOException;
        }
        object = this.bootstrapManager.getBaseUrl() + string;
        return object;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public void setSoapServiceHelper(SoapServiceHelper soapServiceHelper) {
        this.soapServiceHelper = soapServiceHelper;
    }

    public void setIndexManager(ConfluenceIndexManager confluenceIndexManager) {
        this.indexManager = confluenceIndexManager;
    }

    public RemoteServerInfo getServerInfo() throws RemoteException {
        return new RemoteServerInfo();
    }

    public boolean flushIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        this.indexManager.flushQueue();
        return true;
    }

    public boolean clearIndexQueue() throws RemoteException {
        this.soapServiceHelper.assertCanAdministrate();
        this.indexManager.resetIndexQueue();
        return true;
    }
}

