/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSpace
extends RemoteSpaceSummary {
    String description;
    long homePage;

    public RemoteSpace(Space space, WikiStyleRenderer wikiStyleRenderer) {
        super(space);
        if (space.getHomePage() != null) {
            this.homePage = space.getHomePage().getId();
        }
        if (space.getDescription() != null && TextUtils.stringSet((String)space.getDescription().getContent())) {
            this.description = wikiStyleRenderer.convertWikiToXHtml((RenderContext)space.getDescription().toPageContext(), space.getDescription().getContent());
        }
    }

    public RemoteSpace() {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public long getHomePage() {
        return this.homePage;
    }

    public void setHomePage(long l) {
        this.homePage = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemoteSpace)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RemoteSpace remoteSpace = (RemoteSpace)object;
        if (this.homePage != remoteSpace.homePage) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(remoteSpace.description) : remoteSpace.description != null);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.description != null ? this.description.hashCode() : 0);
        n = 29 * n + (int)(this.homePage ^ this.homePage >>> 32);
        return n;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

