/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.confluence.util.GeneralUtil;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteServerInfo {
    private int majorVersion;
    private int minorVersion;
    private int patchLevel;
    private boolean developmentBuild;
    private String buildId = GeneralUtil.getBuildNumber();
    private String baseUrl;

    public RemoteServerInfo() {
        this.setVersion(GeneralUtil.getVersionNumber());
        this.baseUrl = BootstrapUtils.getBootstrapManager().getBaseUrl();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchLevel() {
        return this.patchLevel;
    }

    public boolean isDevelopmentBuild() {
        return this.developmentBuild;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    private void setVersion(String string) {
        if (string.endsWith("dev") || string.endsWith("DEV")) {
            this.developmentBuild = true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".- ");
        this.majorVersion = this.nextNumber(stringTokenizer);
        this.minorVersion = this.nextNumber(stringTokenizer);
        this.patchLevel = this.nextNumber(stringTokenizer);
    }

    private int nextNumber(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            return 0;
        }
        try {
            return Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            this.developmentBuild = true;
            return 0;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

