/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.BootstrapUtils;
import com.atlassian.renderer.util.RendererUtil;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteSearchResult {
    private String type;
    private long id;
    private String title;
    private String url;
    private String excerpt;

    public RemoteSearchResult() {
    }

    public RemoteSearchResult(Addressable addressable) {
        this.setId(addressable.getId());
        this.setType(addressable.getType());
        this.setTitle(addressable.getRealTitle());
        if (addressable instanceof Attachment) {
            this.setUrl(BootstrapUtils.getBootstrapManager().getBaseUrl() + ((Attachment)addressable).getDownloadPath());
        } else {
            this.setUrl(BootstrapUtils.getBootstrapManager().getBaseUrl() + addressable.getUrlPath());
        }
        if (addressable instanceof Mail) {
            this.setExcerpt(((Mail)addressable).getExcerpt());
        } else if (addressable instanceof ContentEntityObject) {
            this.setExcerpt(RendererUtil.summarise((String)((ContentEntityObject)addressable).getContent()));
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setId(long l) {
        this.id = l;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setExcerpt(String string) {
        this.excerpt = string;
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

